<?php if ( ! defined( 'ABSPATH' ) ) exit;

class NF_VimeoUploader_Admin_Settings {

  public function __construct() {
    add_filter( 'ninja_forms_plugin_settings', array($this, 'register_settings'));
    add_filter( 'ninja_forms_plugin_settings_groups', array($this, 'add_vimeo_plugin_settings_group') );
    add_filter( 'ninja_forms_check_setting_vimeo_uploader_access_token', array($this, 'validate_vimeo_access_token'), 10, 1 );

    add_filter( 'ninja_forms_update_setting_vimeo_uploader_access_token', array( $this, 'update_vimeo_access_token' ), 10, 1 );
  }


  /**
   * Registers plugin-wide settings metabox content on the settings page
   *
   * @param  [type] $settings [description]
   * @return [type]           [description]
   */
  public function register_settings($settings) {

    $settings['vimeo_uploader'] = array(
      'vimeo_uploader_access_token' => array(
        'id' => 'vimeo_uploader_access_token',
        'type'  => 'textbox',
        'label' => __( 'Vimeo Access Token', 'ninja-forms-vimeo-uploader' ),
        'desc'  => __('To connect your Vimeo account to your WordPress site, visit <a href="https://vimeography.com/upload/authorize" target="_blank">this page</a> and copy/paste your access token above.', 'ninja-forms-vimeo-uploader'),
      )
    );

    return $settings;
  }

  public function add_vimeo_plugin_settings_group($groups) {
    $groups['vimeo_uploader'] = array(
      'id' => 'vimeo_uploader',
      'label' => __( 'Vimeo Uploader Settings', 'ninja-forms-vimeo-uploader' ),
    );

    return $groups;
  }


  /**
   * Checks the tokens provided by the user and saves them if they are valid.
   *
   * NOTE: This can't actually prevent the value from being saved because NF
   * doesn't allow us to reject an invalid setting, so do our best to provide a message to the user
   * based on the validity of their entry.
   *
   * @access public
   * @param array $setting
   * @return void
   */
  public function validate_vimeo_access_token($setting) {

    // $vimeo_access_token = get_site_option( 'nf_vimeo_uploader_access_token' );

    // if ( $vimeo_access_token ) {
    //   delete_site_option('nf_vimeo_uploader_access_token');
    //   $setting['value'] = $vimeo_access_token;
    // }

    if ( isset( $setting['value'] ) && ! empty( $setting['value'] ) ) {
      try {
        $vimeo = new Vimeography_Vimeo(NULL, NULL, $setting['value'] );
        $response = $vimeo->request('/me');

        if (! $response) {
          $setting['errors'][] = __('Looks like the Vimeo API is having some issues right now. Try this again in a little bit.', 'nf-vimeo-uploader');
        }

        switch ( $response['status'] ) {
          case 200:
            // $setting['errors'][] = sprintf( __('Success! Your Vimeo access token for %1$s has been added and saved.', 'nf-vimeo-uploader'), $response['body']->name );
            break;
          case 401:
            throw new Exception(__("Your Vimeo access token didn't validate. Try again, and double check that you are entering the correct token.", 'nf-vimeo-uploader'));
          case 404:
            throw new Exception(__('how the heck did you score a 404?', 'nf-vimeo-uploader'). $response['body']->error);
          default:
            throw new Exception(__('Unknown response status from the Vimeo API: ', 'nf-vimeo-uploader'). $response['body']->error);
        }

      } catch (Exception $e) {
        $setting['errors'][] = sprintf( __('Dangit. %1$s', 'nf-vimeo-uploader'), $e->getMessage() );
      }
    }

    return $setting;
  }

  /**
   * Update access token Value
   *
   * Before the access token is saved, update the value.
   *
   * @param $setting
   * @return mixed
   */
  public function update_vimeo_access_token( $setting_value ) {
    $setting_value = trim( $setting_value );
    return $setting_value;
  }
}