<?php if (!defined('ABSPATH')) exit;

if ( ! class_exists('NF_Abstracts_SubmissionMetabox') ) return;

final class NF_VimeoUploader_Admin_Metaboxes_Submission extends NF_Abstracts_SubmissionMetabox {

  public function __construct() {
    parent::__construct();

    $this->_title = __('Vimeo Upload', 'ninja-forms-vimeo-uploader');
    $this->_context = 'normal';

    if ( $this->sub && ! $this->sub->get_extra_value( 'vimeo_uploader') ) {
      remove_action( 'add_meta_boxes', array( $this, 'add_meta_boxes' ) );
    }

    if ( $this->sub && $this->sub->get_extra_value( 'vimeo_uploader') ) {
      add_action('admin_enqueue_scripts', array( $this, 'load_scripts' ) );
    }
  }

  /**
   * Render the custom Vimeo video metabox on the submission page.
   * @param  [type] $post    [description]
   * @param  [type] $metabox [description]
   * @return [type]          [description]
   */
  public function render_metabox($post, $metabox) {
    $data = $this->sub->get_extra_value('vimeo_uploader');
    NF_VimeoUploader::template('admin-metabox-submission.html.php', $data);
  }

  /**
   * Load vimeo.js on the individual submission page.
   * @return [type] [description]
   */
  public function load_scripts() {
    wp_enqueue_script('vimeo-player', 'https://player.vimeo.com/api/player.js');
  }
}
