<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Class NF_Admin_CPT_Submission
 */
class NF_VimeoUploader_Admin_CPT_Submission {

  public function __construct() {
    add_filter('nf_edit_sub_user_value', array( $this, 'update_vimeo_uploader_submission' ), 10, 3 );
  }


  /**
   * Update the Vimeo video if the submission is edited from the admin side.
   *
   * @param  [type] $user_value submitted user value from the form
   * @param  [type] $field_id
   * @param  [type] $sub_id     saved submission ID
   * @return [type]             [description]
   */
  public function update_vimeo_uploader_submission($user_value, $field_id, $submission_id) {
    $field_type = Ninja_Forms()->form()->get_field( $field_id )->get_setting('type');

    // Only care if it relates to this plugin.
    if ( ! in_array( $field_type, array('vimeo_uploader_title', 'vimeo_uploader_description') ) ) {
      return $user_value;
    }

    $sub = Ninja_Forms()->form()->get_sub( $submission_id );
    $saved_values = $sub->get_field_values();

    // Don't patch anything if it's the same value.
    if ( $saved_values[$field_type] == $user_value ) {
      return $user_value;
    }

    // Update over on Vimeo
    $extra = $sub->get_extra_value( 'vimeo_uploader' );

    try {
      $params = array();

      if ( $field_type == 'vimeo_uploader_title' ) {
        $params['name'] = $user_value;
      }

      if ( $field_type == 'vimeo_uploader_description' ) {
        $params['description'] = $user_value;
      }

      $resource = $extra['vimeo_resource'];

      $uploader = new NF_VimeoUploader_Actions_VimeoUploader;
      $uploader->patch_video_data( $resource, $params );
    } catch (Exception $e) {
      // Add error message to admin_notices, todo
    }

    return $user_value;
  }
}
