<?php

if ( ! class_exists( 'NF_Vimeo_Uploader' ) ) {

  class NF_Vimeo_Uploader {
    /**
     * The NF_Vimeo_Uploader instance
     *
     * @var object
     */
    private static $instance = NULL;

    /**
     * Creates or returns an instance of this class.
     *
     * @return  NF_Vimeo_Uploader A single instance of this class.
     */
    public static function get_instance() {
      if ( ! isset( self::$instance ) AND ! ( self::$instance instanceof NF_Vimeo_Uploader ) ) {
        self::$instance = new self;
        self::$instance->_define_constants();
        self::$instance->_include_files();
        Mustache_Autoloader::register();

        if ( is_admin() ) {
          new NF_Vimeo_Uploader_Admin_Actions;
          new NF_Vimeo_Uploader_Admin_Scripts;
          new NF_Vimeo_Uploader_Admin_Ajax;
          // new NF_Vimeo_Uploader_Admin_Menu;
        }

        // Can save these in public vars if need to access
        new NF_Vimeo_Uploader_Init;
        new NF_Vimeo_Uploader_Shortcode;
        new NF_Vimeo_Uploader_Register_Metabox;
        new NF_Vimeo_Uploader_Register_Sidebar;
        new NF_Vimeo_Uploader_Register_Dropzone_Field;
        new NF_Vimeo_Uploader_Register_Title_Field;
        new NF_Vimeo_Uploader_Register_Description_Field;
        new NF_Vimeo_Uploader_Scripts;
      }

      return self::$instance;
    }

    /**
     * Empty constructor… boring.
     */
    public function __construct() { }

    /**
     * Define all of the constants used throughout the plugin.
     *
     * @return void
     */
    private function _define_constants() {
      define( 'NF_VIMEO_UPLOADER_URL',  plugin_dir_url(__FILE__) );
      define( 'NF_VIMEO_UPLOADER_PATH', plugin_dir_path(__FILE__) );
      define( 'NF_VIMEO_UPLOADER_ASSETS_URL',  NF_VIMEO_UPLOADER_URL . 'lib/shared/assets/' );
      define( 'NF_VIMEO_UPLOADER_ASSETS_PATH', NF_VIMEO_UPLOADER_PATH. 'lib/shared/assets/' );
      define( 'NF_VIMEO_UPLOADER_BASENAME', plugin_basename( __FILE__ ) );
      define( 'NF_VIMEO_UPLOADER_CURRENT_PAGE', basename( $_SERVER['PHP_SELF'] ) );
    }

    /**
     * Include the files required by Vimeography.
     * @return [type]
     */
    private function _include_files() {
      require_once NF_VIMEO_UPLOADER_PATH . 'lib/exception.php';

      // Require Mustache.php
      if ( ! class_exists('Mustache_Engine') ) {
        require_once NF_VIMEO_UPLOADER_PATH . 'vendor/mustache/mustache/src/Mustache/Autoloader.php';
      }

      // Require Vimeo.php Library
      if ( ! class_exists('Vimeography_Vimeo') ) {
        require_once NF_VIMEO_UPLOADER_PATH . 'vendor/davekiss/vimeo-php/vimeo.php';
      }

      // require_once NF_VIMEO_UPLOADER_PATH . 'lib/ajax.php';
      require_once NF_VIMEO_UPLOADER_PATH . 'lib/init.php';
      require_once NF_VIMEO_UPLOADER_PATH . 'lib/shortcode.php';
      require_once NF_VIMEO_UPLOADER_PATH . 'lib/register-metabox.php';
      require_once NF_VIMEO_UPLOADER_PATH . 'lib/register-sidebar.php';
      require_once NF_VIMEO_UPLOADER_PATH . 'lib/fields/display/dropzone.php';
      require_once NF_VIMEO_UPLOADER_PATH . 'lib/fields/display/title.php';
      require_once NF_VIMEO_UPLOADER_PATH . 'lib/fields/display/description.php';
      require_once NF_VIMEO_UPLOADER_PATH . 'lib/fields/register/dropzone.php';
      require_once NF_VIMEO_UPLOADER_PATH . 'lib/fields/register/title.php';
      require_once NF_VIMEO_UPLOADER_PATH . 'lib/fields/register/description.php';
      require_once NF_VIMEO_UPLOADER_PATH . 'lib/fields/process/title.php';
      require_once NF_VIMEO_UPLOADER_PATH . 'lib/fields/process/description.php';
      require_once NF_VIMEO_UPLOADER_PATH . 'lib/fields/process/dropzone.php';
      require_once NF_VIMEO_UPLOADER_PATH . 'lib/scripts.php';
      require_once NF_VIMEO_UPLOADER_PATH . 'lib/upload.php';

      if ( is_admin() ) {
        require_once NF_VIMEO_UPLOADER_PATH . 'lib/admin/actions.php';
        require_once NF_VIMEO_UPLOADER_PATH . 'lib/admin/scripts.php';
        require_once NF_VIMEO_UPLOADER_PATH . 'lib/admin/ajax.php';
        // require_once NF_VIMEO_UPLOADER_PATH . 'lib/admin/menu.php';
      }
    }

  }
}

NF_Vimeo_Uploader::get_instance();
