<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

class NF_Vimeo_Uploader_Shortcode {
  public function __construct() {
    add_shortcode( 'ninja_forms_vimeo_link', array($this, 'output_vimeo_link') );
  }

  /**
   * Parses the Vimeo Link shortcode to display the link.
   *
   * @param  {[type]} $atts [description]
   * @return {[type]}       [description]
   */
  public function output_vimeo_link( $atts ) {
    global $ninja_forms_processing;

    if ( is_object ( $ninja_forms_processing ) ) {
      $link = $ninja_forms_processing->get_extra_value('_vimeo_uploader_vimeo_link');
    } else {
      //$link = Ninja_Forms()->sub( $sub_id )->get_meta( '_vimeo_uploader_vimeo_link' );
      $link = '';
    }

    if ( ! empty( $link ) ) {
      return sprintf('<a href="%1$s" title="View on Vimeo" target="_blank">%2$s</a>', $link, $link);
    }
  }
}