<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

class NF_Vimeo_Uploader_Scripts {

  public function __construct() {
    add_action( 'ninja_forms_display_css', array( $this, 'frontend_styles' ), 10, 2 );
    add_action( 'ninja_forms_display_js',  array( $this, 'frontend_scripts' ) );
  }


  public function frontend_scripts() {
    global $ninja_forms_loading;

    if ( ! isset( $ninja_forms_loading ) ) {
      return false;
    }

    wp_register_script('resumable', NF_VIMEO_UPLOADER_URL . 'lib/assets/js/resumable.js', array('jquery') );
    wp_register_script('progressbar', NF_VIMEO_UPLOADER_URL . 'lib/assets/js/progressbar.min.js', array('jquery') );
    wp_register_script('nf-vimeo-uploader', NF_VIMEO_UPLOADER_URL . 'lib/assets/js/nf-vimeo-uploader.js', array('jquery', 'resumable', 'progressbar') );

    wp_enqueue_script('resumable' );
    wp_enqueue_script('progressbar');
    wp_enqueue_script('nf-vimeo-uploader' );
  }

  /**
   * [ninja_forms_display_css description]
   * @return [type] [description]
   */
  public function frontend_styles(){
    wp_enqueue_style( 'ninja-forms-vimeo-uploader', NF_VIMEO_UPLOADER_URL . 'lib/assets/css/style.css' );
  }

}