<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

class NF_Vimeo_Uploader_Register_Sidebar {

  public function __construct() {
    add_action( 'admin_init', array( $this, 'register_sidebar_vimeo_uploader_fields' ) );
  }

  /**
   * Adds the white sidebar box to the field editor,
   * which contains all of the different possible Vimeo
   * uploader fields to show on the frontend.
   *
   * @return [type] [description]
   */

  public function register_sidebar_vimeo_uploader_fields(){
    if (!function_exists('nf_get_settings')) {
      return FALSE;
    }
      $plugin_settings = nf_get_settings();
      if ( isset( $plugin_settings['nf_vimeo_uploader_access_token'] ) && ! empty( $plugin_settings['nf_vimeo_uploader_access_token'] ) ) {
        $args = array(
          'name' => __( 'Vimeo Uploader', 'ninja-forms' ),
          'page' => 'ninja-forms',
          'tab'  => 'builder',
          'display_function' => 'ninja_forms_sidebar_display_fields'
        );
        ninja_forms_register_sidebar('vimeo_uploader_fields', $args);
      }
  }

}
