<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

class NF_Vimeo_Uploader_Register_Dropzone_Field {

  public $display;
  public $process;

  public function __construct() {
    add_action( 'init', array( $this, 'register_file_dropzone_field' ) );
    add_filter( 'nf_sub_table_columns', array( $this, 'add_vimeo_link_column'), 10, 2 );
    add_action( 'manage_nf_sub_posts_custom_column', array($this, 'add_vimeo_link_column_values'), 10, 2 );

    $this->display = new NF_Vimeo_Uploader_Display_Dropzone_Field;
    $this->process = new NF_Vimeo_Uploader_Process_Dropzone_Field;
  }


  /**
   * [add_vimeo_link_column description]
   * @param [type] $columns [description]
   * @param [type] $form_id [description]
   */
  public function add_vimeo_link_column($columns, $form_id) {
    $fields = Ninja_Forms()->form( $form_id )->fields;

    foreach ($fields as $field) {
      if ($field['type'] == 'vimeo_uploader_file_dropzone') {
        $columns['vimeo_link'] = 'Vimeo Link';
        return $columns;
      }
    }
    return $columns;
  }

  /**
   * [add_vimeo_link_column description]
   * @param [type] $columns [description]
   * @param [type] $form_id [description]
   */
  public function add_vimeo_link_column_values($column, $sub_id) {

    if ( $column == 'vimeo_link' ) {
      $link = Ninja_Forms()->sub( $sub_id )->get_meta( '_vimeo_uploader_vimeo_link' );

      if ( ! empty( $link ) ) {
        printf('<a href="%1$s" title="View on Vimeo" target="_blank">%2$s</a>', $link, $link);
      }
    }

  }


  /**
   * [register_vimeo_uploader_field description]
   * @return [type] [description]
   */
  public function register_file_dropzone_field() {
    $args = array(
      'name' => 'File Dropzone',
      'edit_options' => array(
        // array(
        //   'type' => 'text',
        //   'name' => 'vimeo_name',
        //   'label' => 'Video Title',
        //   'class' => 'widefat',
        // ),
        array(
          'type' => 'select',
          'name' => 'minimum_user_role',
          'label' => 'Minimum User Role for Uploading',
          'options' => array(
            array( 'name' => 'Admin+',  'value' => 'manage_options' ),
            array( 'name' => 'Editor+', 'value' => 'publish_pages' ),
            array( 'name' => 'Author+', 'value' => 'publish_posts' ),
            array( 'name' => 'Contributor+', 'value' => 'edit_posts' ),
            array( 'name' => 'Subscriber+',  'value' => 'read' ),
            array( 'name' => 'Guests+',  'value' => 'guest' ),
          ),
        ),
        array(
          'type' => 'select',
          'name' => 'video_privacy_settings',
          'label' => 'Video Privacy Settings',
          'options' => array(
            array( 'name' => 'Only Me',           'value' => 'nobody' ),
            array( 'name' => 'Hidden from Vimeo', 'value' => 'disable' ),
            array( 'name' => 'Only My Contacts',  'value' => 'contacts' ),
            array( 'name' => 'Public',            'value' => 'anybody' ),
          ),
        ),
      ),
      'display_function' => array( $this->display, 'display_frontend_vimeo_uploader_fields' ),
      'edit_function'    => array( $this, 'add_vimeo_metadata_to_admin_field_editor' ),
      'sidebar'          => 'vimeo_uploader_fields',
      'default_label'    => 'Upload your Video',
      'admin_label'      => 'Vimeo Uploader',
      //'edit_desc' => false,
      'process_field'    => true,
      'pre_process'      => array($this->process, 'validate_field'),
      'process'          => array($this->process, 'complete_upload'),
      'edit_sub_value'   => array($this, 'edit_submission'),
      'sub_table_value'  => array($this, 'change_submission_table_value'),
    );

    if ( function_exists( 'ninja_forms_register_field' ) ) {
      ninja_forms_register_field( 'vimeo_uploader_file_dropzone', $args );
    }
  }

  /**
   * [edit_submission_value description]
   * @return [type] [description]
   */
  public function edit_submission($field_id, $user_value, $field) {
    $submission_id = intval( $_GET['post'] );
    $link = Ninja_Forms()->sub( $submission_id )->get_meta( '_vimeo_uploader_vimeo_link' );

    try {
      $uploader   = new NF_Vimeo_Uploader_Upload;
      echo $uploader->get_video_embed_code( $link );
    } catch (Exception $e) {
      echo $e->getMessage();
    }

    if ( ! empty( $link ) ) {
      printf('<a href="%1$s" title="View on Vimeo" target="_blank">%2$s</a>', $link, $link);
    }
  }

  /**
   * [change_submission_table_value description]
   * @param  [type] $field_id   [description]
   * @param  [type] $user_value [description]
   * @return [type]             [description]
   */
  public function change_submission_table_value($field_id, $user_value) {
    return $user_value;
  }


  /*
   * This function outputs HTML for the backend editor.
   * The naming convention is: ninja_forms_field_4[custom_value].
   * It will be available as $data[custom_value].
   *
   * $field_id is the id of the field currently being edited.
   * $field_data is an array of the field data, including any custom variables.
   *
   * For the upload plugin, we should show the account details, quota here.
   *
  */
  public function add_vimeo_metadata_to_admin_field_editor( $field_id, $field_data ) {

    try {
      $uploader   = new NF_Vimeo_Uploader_Upload;
      $user       = $uploader->get_user();

      if ( isset( $field_data['add_to_vimeo_album'] ) && $field_data['add_to_vimeo_album'] == 1 ) {
        $display_container = '';
      } else {
        $display_container = ' style="display:none;"';
        $field_data['add_to_vimeo_album'] = 0;
      }
      ?>

      <div class="nf-vimeo-uploader-account">

        <div class="nf-vimeo-uploader-user-profile group">
          <div class="nf-vimeo-uploader-user-thumbnail">
            <?php $user_thumbnail = end($user->pictures); ?>
            <img src="<?php echo $user_thumbnail->link; ?>" width="<?php echo $user_thumbnail->width; ?>" height="<?php echo $user_thumbnail->height; ?>" />
            <span class="nf-vimeo-uploader-account-type <?php echo $user->account; ?>"></span>
          </div>
          <div class="nf-vimeo-uploader-user-data">
            <h1><?php echo $user->name; ?></h1>
            <a href="<?php echo $user->link; ?>" title="Go to <?php echo $user->name; ?> on Vimeo"><?php echo $user->link; ?></a>
          </div>
        </div>

        <div class="nf-vimeo-uploader-quota">
          <span class="nf-vimeo-uploader-quota-remaining"><?php echo size_format($user->upload_quota->space->free); ?></span>
          <input type="text" value="0" class="nf-vimeo-uploader-dial" data-max-space-raw="<?php echo $user->upload_quota->space->max; ?>" data-available-free-space-raw="<?php echo $user->upload_quota->space->free; ?>">

          <h1>Upload Quota</h1>
          <p><?php echo size_format($user->upload_quota->space->free); ?> of <?php echo size_format($user->upload_quota->space->max); ?> available</p>
          <p>You've used <?php echo size_format($user->upload_quota->space->used); ?> this week.</p>
        </div>
      </div> <!-- end sidebar -->

      <?php ninja_forms_edit_field_el_output( $field_id, 'checkbox', __( 'Add uploaded videos to a Vimeo album', 'nf-vimeo-uploader' ), 'add_to_vimeo_album', $field_data['add_to_vimeo_album'], 'wide', '', 'ninja-forms-show-vimeo-albums' ); ?>

      <div id="ninja_forms_field_<?php echo $field_id;?>_vimeo_albums_container" <?php echo $display_container;?>>
        <?php $vimeo_albums = isset( $field_data['vimeo_albums'] ) ? $field_data['vimeo_albums'] : '';?>
        <input type="hidden" id="vimeo-album-selector" name="ninja_forms_field_<?php echo $field_id;?>[vimeo_albums]" value="<?php echo $vimeo_albums; ?>" />
      </div>

      <script>
        (function($){
          $(document).trigger( 'vimeoUploaderDialLoad' );
          $(document).trigger( 'vimeoUploaderAlbumSelectorLoad' );
        }(jQuery))
      </script>

      <!-- <input type="text" name="ninja_forms_field_<?php //echo $field_id;?>[my_value]" value="<?php //echo $my_value;?>"> -->
      <?php
    } catch (Exception $e) {
    ?>
      <div>
        <p><?php echo $e->getMessage(); ?></p>
      </div>
      <?php
    }
  }

}