<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

class NF_Vimeo_Uploader_Register_Description_Field {

  public $display;
  public $process;

  public function __construct() {
    add_action( 'init', array( $this, 'register_vimeo_description_field') );
    add_filter( 'ninja_forms_display_field_wrap_class', array($this, 'add_field_wrap_classes'), 10, 3 );
    $this->display = new NF_Vimeo_Uploader_Display_Description_Field;
    $this->process = new NF_Vimeo_Uploader_Process_Description_Field;
  }

  /**
   * [register_vimeo_url_field description]
   * @return [type] [description]
   */
  public function register_vimeo_description_field() {
    $args = array(
      'name'             => 'Video Description',
      'sidebar'          => 'vimeo_uploader_fields',
      'display_function' => array( $this->display, 'display_frontend_vimeo_description_field'),
      'edit_sub_value'   => array( $this->display, 'edit_submission_vimeo_description' ), // The output that shows on the edit submission page, admin only. default is textbox
    );

    if ( function_exists( 'ninja_forms_register_field' ) ) {
      ninja_forms_register_field( 'vimeo_uploader_description', $args );
    }
  }

  /**
   * [add_field_wrap_classes description]
   * @param [type] $field_wrap_class [description]
   * @param [type] $field_id         [description]
   * @param [type] $field_row        [description]
   */
  public function add_field_wrap_classes($field_wrap_class, $field_id, $field_row) {
    if ( $field_row['type'] == 'vimeo_uploader_description') {
      $field_wrap_class .= ' textarea-wrap';
    }
    return $field_wrap_class;
  }

}