<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

class NF_Vimeo_Uploader_Process_Dropzone_Field {

  public function __construct() {
    add_action( 'nf_save_sub', array( $this, 'add_vimeo_fields') );
  }

  /**
   * [validate_required_field description]
   * @param  [type] $field_id   [description]
   * @param  [type] $user_value [description]
   * @return [type]             [description]
   */
  public function validate_field($field_id, $user_value) {
    global $ninja_forms_processing;

    $settings = ninja_forms_get_field_by_id($field_id);

    if ($settings['data']['req'] == 1) {

      $fields = array(
        'complete_uri' => $ninja_forms_processing->get_extra_value('_nf_vimeo_uploader_complete_uri'),
        'filename'     => $ninja_forms_processing->get_extra_value('_nf_vimeo_uploader_filename')
      );

      // Add error if any of the fields are empty.
      foreach ($fields as $name => $value) {
        if ( empty( $value ) ) {
          $ninja_forms_processing->add_error('required-' . $field_id, __('This is a required field', 'nf-vimeo-uploader'), $field_id );
          return;
        }
      }

    }
  }

  /**
   * Close upload ticket, patch video details
   * and save video URL to form submission.
   * 
   * @return [type] [description]
   */
  public function complete_upload($dropzone_field_id, $user_value) {
    global $ninja_forms_processing;

    $extras = array(
      'complete_uri' => $ninja_forms_processing->get_extra_value('_nf_vimeo_uploader_complete_uri'),
      'filename'     => $ninja_forms_processing->get_extra_value('_nf_vimeo_uploader_filename')
    );

    $settings = ninja_forms_get_field_by_id($dropzone_field_id);
    $fields = $ninja_forms_processing->get_all_fields();

    $vimeo_fields = array();
    $vimeo_field_types = array(
      'vimeo_uploader_title',
      'vimeo_uploader_description',
    );

    // Ugly as sin, but only way to find out the field type
    // based on the user-submitted index
    if ( is_array( $fields ) ) {
      foreach ( $fields as $field_id => $user_value ) {
        $field = $ninja_forms_processing->get_field_settings($field_id);
        if ( in_array($field['type'], $vimeo_field_types) ) {
          $vimeo_fields[$field['type']] = array(
            'field_id' => $field_id,
            'user_value' => $user_value,
            'settings' => $field,
          );
        }
      }
    }

    $name = ! empty( $vimeo_fields['vimeo_uploader_title']['user_value'] ) ? $vimeo_fields['vimeo_uploader_title']['user_value'] : $extras['filename'];

    $params = array(
      'name' => $name,
      'description'  => $vimeo_fields['vimeo_uploader_description']['user_value'],
      'privacy.view' => $settings['data']['video_privacy_settings'],
    );

    try {
      $uploader     = new NF_Vimeo_Uploader_Upload;
      $resource     = $uploader->complete_upload( $extras['complete_uri'] );

      // Patch video data
      $uploader->patch_video_data( $resource, $params );

      $video = $uploader->get_video( $resource );

      // Save the link so we can add it as meta when the submission is created
      $ninja_forms_processing->update_extra_value('_vimeo_uploader_vimeo_resource', $resource);
      $ninja_forms_processing->update_extra_value('_vimeo_uploader_vimeo_link', $video->link);

      if ($settings['data']['add_to_vimeo_album'] == 1 && ! empty($settings['data']['vimeo_albums']) ) {

        $albums = explode(',', $settings['data']['vimeo_albums']);

        foreach ($albums as $album) {
          $album_id = array();
          $match = preg_match('/\/users\/(?:\d+)\/albums\/(\d+)/', $album, $album_id);
          if ($match == 1) {
            $result = $uploader->put_video_in_album($video->uri, $album_id[1]);
          }
        }
      }

    } catch (Exception $e) {

    }

  }


  /**
   * [add_vimeo_fields description]
   * @param [type] $submission_id [description]
   */
  public function add_vimeo_fields($submission_id) {
    global $ninja_forms_processing;

    // Get all of our extra values that we want to associate with this submission
    $link = $ninja_forms_processing->get_extra_value('_vimeo_uploader_vimeo_link');
    $resource = $ninja_forms_processing->get_extra_value('_vimeo_uploader_vimeo_resource');

    Ninja_Forms()->sub( $submission_id )->update_meta( '_vimeo_uploader_vimeo_link', $link );
    Ninja_Forms()->sub( $submission_id )->update_meta( '_vimeo_uploader_vimeo_resource', $resource );
  }


}