<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

class NF_Vimeo_Uploader_Process_Description_Field {

  public function __construct() {
    add_filter('nf_edit_sub_user_value', array( $this, 'update_vimeo_uploader_submission' ), 10, 3 );
  }

  /**
   * [update_vimeo_uploader_submission description]
   * @param  [type] $user_value [description]
   * @param  [type] $field_id   [description]
   * @param  [type] $sub_id     [description]
   * @return [type]             [description]
   */
  public function update_vimeo_uploader_submission($user_value, $field_id, $submission_id) {
    $field = ninja_forms_get_field_by_id( $field_id );

    if ($field['type'] == 'vimeo_uploader_description') {

      try {
        $params = array();
        $params['description'] = $user_value;
        $resource = Ninja_Forms()->sub( $submission_id )->get_meta( '_vimeo_uploader_vimeo_resource' );

        $uploader     = new NF_Vimeo_Uploader_Upload;
        $uploader->patch_video_data( $resource, $params );
      } catch (Exception $e) {
        // Add error message to admin_notices, todo
      }
    }

    return $user_value;
  }

}