<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

class NF_Vimeo_Uploader_Display_Title_Field {

  /*
   * This function only has to output the specific field element. The wrap is output automatically.
   *
   * $field_id is the id of the field currently being displayed.
   * $data is an array the possibly modified field data for the current field.
   *
  */
  public function display_frontend_vimeo_title_field( $field_id, $data ) {

    global $ninja_forms_loading, $ninja_forms_processing;

    if ( isset( $ninja_forms_loading ) ) {
      $value = '';
    }

    if ( isset( $ninja_forms_processing ) ) {
      $value = $ninja_forms_processing->get_field_value( $field_id );
    }

    $field_class = ninja_forms_get_field_class( $field_id );

    $label_pos        = isset( $data['label_pos'] )        ? $data['label_pos']        : 'left';
    $label            = isset( $data['label'] )            ? $data['label']            : '';
    $input_limit      = isset( $data['input_limit'] )      ? $data['input_limit']      : '';
    $input_limit_type = isset( $data['input_limit_type'] ) ? $data['input_limit_type'] : '';
    $input_limit_msg  = isset( $data['input_limit_msg'] )  ? $data['input_limit_msg']  : 'left';
    $my_value         = isset( $data['my_value'] )         ? $data['my_value']         : '';

    ?>
    <input id="ninja_forms_field_<?php echo $field_id;?>" data-input-limit="<?php echo $input_limit;?>" data-input-limit-type="<?php echo $input_limit_type;?>" data-input-limit-msg="<?php echo $input_limit_msg;?>" name="ninja_forms_field_<?php echo $field_id;?>" type="text" class="<?php echo $field_class;?>" value="<?php echo $value;?>" rel="<?php echo $field_id;?>" />
    <?php
  }

}