<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

class NF_Vimeo_Uploader_Display_Dropzone_Field {

  /*
   * This function only has to output the specific field element. The wrap is output automatically.
   *
   * $field_id is the id of the field currently being displayed.
   * $data is an array the possibly modified field data for the current field.
  */
  public function display_frontend_vimeo_uploader_fields( $field_id, $data ){

    $capability = apply_filters('nf-vimeo-uploader/upload-capability', $data['minimum_user_role']);

    if ($capability !== 'guest') {
      if ( ! current_user_can( $capability ) ) { ?>
        <div>
          <p><?php _e('You do not have permission to upload a video.', 'nf-vimeo-uploader'); ?></p>
        </div>
      <?php
        return;
      }
    }

    try {

      global $ninja_forms_processing, $ninja_forms_loading;

      if ( isset ( $ninja_forms_loading ) ) {
        $uploader     = new NF_Vimeo_Uploader_Upload;
        $ticket       = $uploader->get_streaming_upload_ticket();
        $complete_uri = $ticket->complete_uri;
        $form_id      = $ninja_forms_loading->get_form_ID();
      }

      if ( isset ( $ninja_forms_processing ) ){
        $complete_uri      = $ninja_forms_processing->get_extra_value('_nf_vimeo_uploader_complete_uri');
        $video_filename    = $ninja_forms_processing->get_extra_value( '_nf_vimeo_uploader_filename' );
      }

      ?>

      <?php if ( ! isset( $video_filename ) ) : ?>
        <script>
          (function($){
            $(document).ready(function() {
              nf_vimeo_uploader.config.form_id = <?php echo $form_id ?>;
              nf_vimeo_uploader.config.upload_link = "<?php echo $ticket->upload_link_secure; ?>";
              nf_vimeo_uploader.config.init();
            });
          })(jQuery)
        </script>
      <?php endif; ?>

      <div class="ninja-forms-vimeo-uploader-file <?php if ( isset($video_filename) && ! empty( $video_filename ) ) echo 'nf-vimeo-uploader-completed'; ?>">
        <div class="ninja-forms-vimeo-uploader-file-dropzone" ondragenter="jQuery(this).addClass('ninja-forms-vimeo-uploader-file-dropzone-dragover');" ondragend="jQuery(this).removeClass('ninja-forms-vimeo-uploader-file-dropzone-dragover');" ondrop="jQuery(this).removeClass('ninja-forms-vimeo-uploader-file-dropzone-dragover');">
          
          <?php $text = isset($video_filename) && ! empty( $video_filename ) ? $video_filename : apply_filters( 'nf-vimeo-uploader/dropzone-message', __('Drop video file here to upload', 'nf-vimeo-uploader') ); ?>
          <h3><?php echo $text; ?></h3>

          <div class="nf-vimeo-uploader-progress">
            <div class="nf-vimeo-uploader-progress-bar"></div>
            <span class="nf-vimeo-uploader-percentage"></span>
          </div>

          <div class="nf-vimeo-uploader-complete" <?php if ( isset( $video_filename ) && ! empty( $video_filename ) ) echo 'style="display: block;"'; ?>><?php _e('Your video has been uploaded.', 'nf-vimeo-upload'); ?></div>
        </div>

        <a class="ninja-forms-vimeo-uploader-file-browser">or, select from your computer</a>
      </div>

      <input type="hidden" name="_nf_vimeo_uploader_complete_uri" value="<?php echo $complete_uri;?>">

      <?php if ( isset($video_filename) && ! empty( $video_filename ) ) : ?>
        <input type="hidden" name="_nf_vimeo_uploader_filename" value="<?php echo $video_filename; ?>" />
      <?php endif; 

    } catch (Exception $e) {
      echo $e->getMessage();
    }

  }

}