<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

class NF_Vimeo_Uploader_Display_Description_Field {

  /*
   * This function only has to output the specific field element. The wrap is output automatically.
   *
   * $field_id is the id of the field currently being displayed.
   * $data is an array the possibly modified field data for the current field.
   *
  */
  public function display_frontend_vimeo_description_field( $field_id, $data ){

    global $ninja_forms_loading, $ninja_forms_processing;

    if ( isset( $ninja_forms_loading ) ) {
      $value = '';
    }

    if ( isset( $ninja_forms_processing ) ) {
      $value = $ninja_forms_processing->get_field_value( $field_id );
    }
  
    $field_class = ninja_forms_get_field_class( $field_id );

    $label_pos        = isset( $data['label_pos'] )        ? $data['label_pos']        : 'left';
    $label            = isset( $data['label'] )            ? $data['label']            : '';
    $input_limit      = isset( $data['input_limit'] )      ? $data['input_limit']      : '';
    $input_limit_type = isset( $data['input_limit_type'] ) ? $data['input_limit_type'] : '';
    $input_limit_msg  = isset( $data['input_limit_msg'] )  ? $data['input_limit_msg']  : 'left';
    $my_value         = isset( $data['my_value'] )         ? $data['my_value']         : '';

    ?>
    <textarea id="ninja_forms_field_<?php echo $field_id;?>" data-input-limit="<?php echo $input_limit;?>" data-input-limit-type="<?php echo $input_limit_type;?>" data-input-limit-msg="<?php echo $input_limit_msg;?>" name="ninja_forms_field_<?php echo $field_id;?>" class="<?php echo $field_class;?>" rel="<?php echo $field_id;?>" ><?php echo $value;?></textarea>
    <?php
  }

  /**
   * Edit submission value output function
   *
   * @since 2.7
   * @return void
   */
  public function edit_submission_vimeo_description( $field_id, $user_value ) {
    ?>
    <textarea name="fields[<?php echo $field_id; ?>]"><?php echo $user_value; ?></textarea>
    <?php
  }

}