window.nf_vimeo_uploader = window.nf_vimeo_uploader || {};

/* Modeled after http://jsfiddle.net/elijahmanor/MVNBz/22/ */
(function(config, $, undefined) {

  config.upload_link = "";
  config.form_id     = ""; /* Used to hide/show the nearest submit button while uploading */

  var progress,
      filename;

  $(document).on('submitResponse.example', function( e, response ){
    if ( response.errors == false ) {
        // Code to be fired upon a submission here
    }
    return true;
  });

  config.init = function() {

    progress = new ProgressBar.Line('.nf-vimeo-uploader-progress-bar', {
      color: "#27ae60",
      trailColor: "#999",
      strokeWidth: 0.5,
      easing: "easeIn",
      duration: 200
    });

    var r = new Resumable({
      target              : config.upload_link, /* target URL for request */
      testChunks          : true,
      simultaneousUploads : 1,
      method              : 'octet',
      uploadMethod        : 'PUT',
      preprocess: function(chunk){
        if (chunk.startByte > 0) {
          chunk.opts.headers = {
            /* 'Content-Length': chunk.fileObjSize, */
            /* 'Content-Type'  : 'video/mp4', */
            'Content-Range' : 'bytes ' + chunk.startByte + '-' + chunk.endByte + '/' + chunk.fileObjSize
          };
        }
        /* console.log('Preprocessing chunk ' + chunk.offset); */
        /* console.log('Chunk #' + chunk.offset + ' state is ' + chunk.preprocessState); */
        chunk.preprocessFinished();
        /* console.log('Preprocess complete'); */
      }
    });

    /* Resumable.js isn't supported, fall back on a different method (form ticket) */
    /* if(! r.support) location.href = '/default-uploader'; */

    r.assignBrowse( $('.ninja-forms-vimeo-uploader-file-browser') );
    r.assignDrop( $('.ninja-forms-vimeo-uploader-file-dropzone') );

    /* Event listeners */
    r.on('fileAdded', function(file){
      filename = file.fileName;
      $( '#nf_submit_'     + config.form_id ).hide();
      $( '#nf_processing_' + config.form_id ).show();

      $('.ninja-forms-vimeo-uploader-file-dropzone').show();

      $('.ninja-forms-vimeo-uploader-file').addClass('nf-vimeo-uploader-uploading');
      $('.ninja-forms-vimeo-uploader-file-dropzone h3').text(filename);
      r.upload();
    });

    r.on('fileSuccess', function(file){
      console.log(file);
    });

    r.on('error', function(file, message){
      console.log(file);
      console.log(message);
    });

    r.on('fileProgress', function(file){
      var rounded = Math.round( file.progress()  * 1000 ) / 10;
      var percent = rounded.toFixed(1) + '%';
      $('.nf-vimeo-uploader-percentage').html(percent);

      progress.animate(file.progress(), {
          duration: 800
      }, function() {
          /* console.log('Animation has finished'); */
      });

      /* $.each(file.chunks, function(i, chunk){
        if (chunk.status() == 'uploading') {
          console.log('Uploading chunk ' + i);
        }
      }); */

    });

    /* Upload complete */
    r.on('complete', function(){

      $( '#nf_processing_' + config.form_id ).hide();
      $( '#nf_submit_'     + config.form_id ).show();

      $('.ninja-forms-vimeo-uploader-file').addClass('nf-vimeo-uploader-completed');

      var confirmation = $('<input />', {
        name: '_nf_vimeo_uploader_filename',
        value: filename,
        type: 'hidden'
      });

      $( 'input[name="_nf_vimeo_uploader_complete_uri"]').after(confirmation);

    });

  };

}( window.nf_vimeo_uploader.config = window.nf_vimeo_uploader.config || {}, jQuery ));
