<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

class NF_Vimeo_Uploader_Admin_Scripts {

  public function __construct() {
    add_action( 'admin_enqueue_scripts', array($this, 'admin_scripts') );
  }

  /**
   * [admin_scripts description]
   * @param  [type] $hook [description]
   * @return [type]       [description]
   */
  public function admin_scripts( $hook ) {

    global $pagenow, $typenow;
    if ( ( $pagenow == 'edit.php' || $pagenow == 'post.php' ) || $typenow == 'nf_sub' ) {
      wp_register_script('fitvids', '//cdnjs.cloudflare.com/ajax/libs/fitvids/1.1.0/jquery.fitvids.min.js', array('jquery') );
      wp_enqueue_script('fitvids');
    }

    // if ( 'toplevel_page_ninja-forms' != $hook ) {
    //   return;
    // }

    wp_register_script( 'knob', NF_VIMEO_UPLOADER_URL . 'lib/admin/assets/js/jquery.knob.js', array('jquery') );
    wp_enqueue_script('knob');

    wp_register_script( 'select2', NF_VIMEO_UPLOADER_URL . 'lib/admin/assets/js/select2-3.5.2/select2.min.js', array('jquery') );
    wp_enqueue_script('select2');

    wp_register_script( 'nf-vimeo-uploader-admin', NF_VIMEO_UPLOADER_URL . 'lib/admin/assets/js/vimeo-uploader-admin.js', array('jquery', 'knob') );
    wp_enqueue_script( 'nf-vimeo-uploader-admin' );

    wp_register_style('nf-vimeo-uploader-admin', NF_VIMEO_UPLOADER_URL . 'lib/admin/assets/css/screen.css');
    wp_enqueue_style('nf-vimeo-uploader-admin');

    wp_register_style('select2', NF_VIMEO_UPLOADER_URL . 'lib/admin/assets/js/select2-3.5.2/select2.css');
    wp_enqueue_style('select2');

  }

}