(function($){

  function init_dial() {
    var $dial = $('.nf-vimeo-uploader-dial');

    $dial.knob({
      'readOnly': true,
      'displayInput': false,
      'min':0,
      'max': $dial.data('max-space-raw') / 10000000,
      'width': 100,
      'height': 100
    });

    $({ value: 0 }).delay(1000).animate({
      value: $dial.data('available-free-space-raw') / 10000000
    }, {
      duration: 1000,
      easing: 'swing',
      progress: function () {
        $dial.val(Math.round(this.value)).trigger('change');
      }
    });
  }

  function init_album_selector() {
    $('#vimeo-album-selector').select2({
      placeholder: "Select Album(s)",
      multiple: true,
      id: function(element) {
        return element.id + '*|*' + element.text;
      },
      initSelection : function (element, callback) {
        var data = [];
        $(element.val().split(",")).each(function () {
          var item = this.split('*|*');
          data.push({
            id: item[0],
            text: item[1]
          });
        });
        callback(data);
      },
      formatAjaxError: function(jqXHR, textStatus, errorThrown) {
        console.log(jqXHR.responseText);
        return 'Could not get albums :(';
      },
      ajax: {
        url: ajaxurl,
        dataType: 'json',
        quietMillis: 250,
        data: function(term, page) {
          return {
            q: term, // search term
            page: page,
            action: 'nf_vimeo_uploader_get_albums'
          };
        },
        results: function(response, page) { // parse the results into the format expected by select2
          var more = (page * 50) < response.body.total; // whether or not there are more results available
          var results = []

          $.each(response.body.data, function(i, v) {
            var obj = {
              id: v.uri,
              text: v.name
            }
            results.push(obj);
          });

          // notice we return the value of more so Select2 knows if more results can be loaded
          return { results: results, more: more };
        },
        cache: true
      }
    });
  }

  $(document).on('vimeoUploaderDialLoad', function() {
    init_dial();
  });

  $(document).on('vimeoUploaderAlbumSelectorLoad', function() {
    init_album_selector();
  });

  $(document).ready(function(e){

    $(document).on("change", ".ninja-forms-show-vimeo-albums", function(t) {
      var n = this.id.replace("ninja_forms_field_", "");
      n = n.replace("_add_to_vimeo_album", "");
      $("#ninja_forms_field_" + n + "_vimeo_albums_container").toggle();
    });

    if ( typeof(fitVids) === typeof(Function) ) {
      $('.type-vimeo_uploader_file_dropzone').fitVids();
    }

  });
}(jQuery))