<?php

if (!defined('ABSPATH'))
    exit;

/*
 * Plugin Name: Ninja Forms - Capsule CRM
 * Plugin URI: http://lb3computingsolutions.com
 * Description: Fully integrate your website with Capsule using the power of Ninja Forms
 * Version: 3.2.3
 * Author: Stuart Sequeira
 * Author URI: http://lb3computingsolutions.com/about
 * Text Domain: ninja-forms-capsule-crm
 *
 * Copyright 2016 Stuart Sequeira.
 */

if (version_compare(get_option('ninja_forms_version', '0.0.0'), '3.0.0', '<') || get_option('ninja_forms_load_deprecated', FALSE)) {


    // last updated NF2 version used in deprecated
    if (!defined('NF2CAPSULECRM_VERSION')) {
        define('NF2CAPSULECRM_VERSION', '1.6.0');
    }

    // deprecated folder url
    if (!defined('NF2CAPSULECRM_PLUGIN_URL')) {
        define('NF2CAPSULECRM_PLUGIN_URL', plugin_dir_url(__FILE__));
    }

    // deprecated folder path
    if (!defined('NF2CAPSULECRM_PLUGIN_DIR')) {
        define('NF2CAPSULECRM_PLUGIN_DIR', plugin_dir_path(__FILE__));
    }

    // deprecated root file
    if (!defined('NF2CAPSULECRM_PLUGIN_FILE')) {
        define('NF2CAPSULECRM_PLUGIN_FILE', __FILE__);
    }

    // define Capsule mode as 2.9x
    if (!defined('NFCAPSULECRM_MODE')) {
        define('NFCAPSULECRM_MODE', '2.9x');
    }
    include 'deprecated/ninja-forms-capsule-crm-deprecated.php';
} else {

    // define Capsule mode as POST3
    if (!defined('NFCAPSULECRM_MODE')) {
        define('NFCAPSULECRM_MODE', 'POST3');
    }
    if (!defined('NFCAPSULECRM_PLUGIN_DIR')) {
        define('NFCAPSULECRM_PLUGIN_DIR', plugin_dir_path(__FILE__));
    }
    /*
     * Include shared functions
     * 
     * NFCAPSULECRM_MODE must be defined before including
     */
    include 'includes/Admin/DeprecatedFunctions.php';

    include 'includes/Admin/Notices.php';
    
    include 'includes/Helper/Constants.php';
    include 'includes/Helper/Functions.php';
    include 'includes/Helper/CommLog.php';
    include 'includes/Helper/ValidateFields.php';
    include 'includes/Helper/Listener.php';
    include 'includes/Helper/Tokens.php';
    include 'includes/Helper/Auth.php';
    
    // TODO: delete file AdvancedCommands once confirmed completely unused


    /**
     * Class NF_CapsuleCRM
     */
    final class NF_CapsuleCRM {

        const VERSION = '3.2.3';
        const SLUG = 'capsule-crm';
        const NAME = 'Capsule CRM';
        const AUTHOR = 'Stuart Sequeira';
        const PREFIX = 'NF_CapsuleCRM';

        /**
         * @var NF_CapsuleCRM
         * @since 3.0
         */
        private static $instance;

        /**
         * Plugin Directory
         *
         * @since 3.0
         * @var string $dir
         */
        public static $dir = '';

        /**
         * Plugin URL
         *
         * @since 3.0
         * @var string $url
         */
        public static $url = '';

        /**
         * True if alternate processing is enabled, false if not
         * @var boolean
         */
        protected $alt_process_enabled;

        /**
         * Configured field map array, optionally filtered
         * @var array
         */
        protected $field_map_lookup;

        /**
         * Main Plugin Instance
         *
         * Insures that only one instance of a plugin class exists in memory at any one
         * time. Also prevents needing to define globals all over the place.
         *
         * @since 3.0
         * @static
         * @static var array $instance
         * @return NF_CapsuleCRM Highlander Instance
         */
        public static function instance() {

            if (!isset(self::$instance) && !(self::$instance instanceof NF_CapsuleCRM)) {
                self::$instance = new NF_CapsuleCRM();

                self::$dir = plugin_dir_path(__FILE__);

                self::$url = plugin_dir_url(__FILE__);

                /*
                 * Register our autoloader
                 */
                spl_autoload_register(array(self::$instance, 'autoloader'));
            }

            return self::$instance;
        }

        public function __construct() {
            /*
             * load the global variables
             * function in Admin/Functions.php
             */
            nfcapsule_load_globals();

            /*
             * Set up Licensing
             */
            add_action('admin_init', array($this, 'setup_license'));

            /*
             * Create Admin settings
             */
            add_action('ninja_forms_loaded', array($this, 'setup_admin'));


            /*
             * Load Templates
             */
            add_action('ninja_forms_builder_templates', array($this, 'builder_templates'));

            /*
             * Register Actions
             */
            add_filter('ninja_forms_register_actions', array($this, 'register_actions'));

            $this->alt_process_enabled();

            $this->load_config_variables();
        }

        public function register_actions($actions) {

            // key needs to match $_name property from action
            $actions[NF_CapsuleCRM_Constants::ACTION_KEY] = new NF_CapsuleCRM_Actions_AddToCapsule();

            return $actions;
        }

        /*
         * Set up the licensing
         */

        public function setup_license() {

            if (!class_exists('NF_Extension_Updater'))
                return;

            new NF_Extension_Updater(self::NAME, self::VERSION, self::AUTHOR, __FILE__, self::SLUG);
        }

        /**
         * Create the settings page
         */
        public function setup_admin() {

            if (!is_admin())
                return;

            new NF_CapsuleCRM_Admin_Settings();
        }

        /**
         * Returns a configuration specified in a given Config file
         * @param string $file_name
         * @return mixed
         */
        public static function config($file_name) {

            return include self::$dir . 'includes/Config/' . $file_name . '.php';
        }

        /**
         * Includes a specific file in an Includes directory
         * 
         * @param string $sub_dir
         * @param string $file_name
         */
        public static function file_include($sub_dir, $file_name) {

            include self::$dir . 'includes/' . $sub_dir . '/' . $file_name . '.php';
        }

        /**
         * Creates a template for display
         * 
         * @param string $file_name
         * @param array $data
         * @return mixed
         */
        public static function template($file_name = '', array $data = array()) {

            if (!$file_name) {
                return;
            }
            extract($data);

            include self::$dir . 'includes/Templates/' . $file_name;
        }

        public function autoloader($class_name) {

            if (class_exists($class_name))
                return;

            if (false === strpos($class_name, self::PREFIX))
                return;

            $class_name = str_replace(self::PREFIX, '', $class_name);
            $classes_dir = realpath(plugin_dir_path(__FILE__)) . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR;
            $class_file = str_replace('_', DIRECTORY_SEPARATOR, $class_name) . '.php';

            if (file_exists($classes_dir . $class_file)) {
                require_once $classes_dir . $class_file;
            }
        }

        /**
         * Sets variable true if alternate processing is enabled, false if not
         * @param boolean   
         * 
         */
        protected function alt_process_enabled() {

            $advanced_commands = NF_CapsuleCRM_Functions::extract_advanced_codes();

            $alternate_processing_command = 'enable_alternate_processing';

            if (!in_array($alternate_processing_command, $advanced_commands)) {

                $this->alt_process_enabled = FALSE;
            } else {

                $this->alt_process_enable = TRUE;
            }
        }

        /**
         * Boolean for alternate process enabled
         * 
         * @return boolean
         */
        public function is_alt_enabled() {

            return $this->alt_process_enabled;
        }

        /** Extracts support data for use throughout */
        public function extract_support_data() {

            $settings_array = self::config('PluginSettings');

            $stored_support_data = get_option(NF_CapsuleCRM_Constants::SUPPORT_DATA);

            foreach ($settings_array as $key => $settings) {

                if ('html' != $settings['type']) {
                    continue;
                }

                if (!isset($stored_support_data[$key])) {

                    $stored_support_data[$key] = array();
                }
            }

            $this->support_data = $stored_support_data;
        }

        /**
         * Modify the global support data
         * 
         * This doesn't update the database automatically to minimize db calls.
         * Several 'modify' functions can be used consecutively and updated
         * with a single 'update' command.
         * 
         * @param string $key Key under which data is stored
         * @param mixed $value Data to be stored
         * @param boolean $append Append the data to the end or replace current
         */
        public function modify_support_data($key = '', $value = '', $append = false) {

            if (0 == strlen($key)) {
                $key = 'no_key';
            }

            /*
             * Save three previous values
             * Revisit to save more if needed
             */
            if ($append) {
                $count = count($this->support_data[$key]);

                if (3 < $count) {

                    array_shift($this->support_data[$key]);
                }

                $this->support_data[$key][] = $value;
            } else {

                $this->support_data[$key] = $value;
            }
        }

        /**
         * Updates the db with the support data
         * 
         * Optional 'debug_only' is used for more frequent updates that are
         * only done when in debug
         * 
         * @param string $debug_only
         */
        public function update_support_data($debug_only = '') {

            NF_CapsuleCRM_Functions::add_advanced_command_filters('debug_mode');

            $debug_mode = apply_filters('nfcapsulecrm_debug_mode', false);

            /*
             * return if value is only set in debug mode and debug mode is off
             */
            if ('debug' == $debug_only && !$debug_mode) {

                return;
            }

            update_option(NF_CapsuleCRM_Constants::SUPPORT_DATA, $this->support_data);
        }

        /**
         * Returns the support data stored in the db
         * @return array 
         */
        public function get_support_data() {

            if (empty($this->support_data)) {

                return false;
            } else {

                return $this->support_data;
            }
        }

        /**
         * Loads configured settings easy access
         */
        protected function load_config_variables() {

            $temp = self::config('FieldMapLookup');

            if ($this->is_alt_enabled()) {

                $this->field_map_lookup = apply_filters('nfcapsulecrm_filter_field_map_lookup', $temp);
            } else {
                $this->field_map_lookup = $temp;
            }
        }

        /**
         * Returns the configured field map array
         * @return array
         */
        public function get_field_map_lookup() {

            if (empty($this->field_map_lookup)) {

                return array();
            } else {

                return $this->field_map_lookup;
            }
        }

    }

    /**
     * The main function responsible for returning The Highlander Plugin
     * Instance to functions everywhere.
     *
     * Use this function like you would a global variable, except without needing
     * to declare the global.
     *
     * @since 3.0
     * @return {class} Highlander Instance
     */
    function NF_CapsuleCRM() {
        return NF_CapsuleCRM::instance();
    }

    NF_CapsuleCRM();
}

/*
 * Upgrade from v2.9x
 */
add_filter('ninja_forms_upgrade_settings', 'NF_CapsuleCRM_Upgrade');

function NF_CapsuleCRM_Upgrade($data) {

    /*
     * Sitewide settings
     * Found in deprecated settings
     */
    $plugin_settings = get_option('nfcapsulecrm_settings', array(
        'nfcapsulecrm_authtoken' => '',
        'nfcapsulecrm_subdomain' => '',
            )
    );

    Ninja_Forms()->update_settings(array(
        'nfcapsulecrm_authtoken' => $plugin_settings['nfcapsulecrm_authtoken'],
        'nfcapsulecrm_subdomain' => $plugin_settings['nfcapsulecrm_subdomain'],
            )
    );

    /*
     * Form settings
     * Found in deprecated form settings
     * Action settings found in Addto{CRM} action
     */
    if (isset($data['settings']['nfcapsulecrm-add-to-leads']) && 1 == $data['settings']['nfcapsulecrm-add-to-leads']) {

        /*
         * Use addtoaction name
         */
        $new_action = array(
            'type' => 'addtocapsule',
            'label' => __('Add to Capsule CRM', 'ninja-forms-capsule-crm'),
        );

        /*
         * duplicate check
         * Form settings are transferred into action settings
         */
        if (isset($data['settings']['nfcapsulecrm-check-for-existing-person']) && 'suggest-merge' == $data['settings']['nfcapsulecrm-check-for-existing-person']) {

            $new_action['duplicate_check'] = true;
        } else {

            $new_action['duplicate_check'] = false;
        }


        $fieldmap_lookup = nfcapsulecrm_upgrade_fieldmap_lookup();

        foreach ($data['fields'] as $key => $field) {

            /*
             * From deprecated field-registration
             */
            if (!isset($field['data']['nfcapsulecrm_field_map']) || 'none' == $field['data']['nfcapsulecrm_field_map']) {
                // this field does not have a field map
                continue;
            } else {

                /*
                 * Check if value is in lookup array, if not, transfer existing value
                 * If not in lookup, it is a custom field
                 */
                if (isset($fieldmap_lookup[$field['data']['nfcapsulecrm_field_map']])) {

                    $fieldmap_key = $fieldmap_lookup[$field['data']['nfcapsulecrm_field_map']];
                } else {

                    $fieldmap_key = $field['data']['nfcapsulecrm_field_map'];
                }
            }

            /*
             * Use ActionFieldMapSettings key
             * Field map settings are nested array inside the keyed action setting
             */
            $new_action['capsule_field_map'][] = array(
                'form_field' => '{field:' . $field['id'] . '}',
                'field_map' => $fieldmap_key,
                'entry_type' => $field['data']['nfcapsulecrm_entry_type'],
                'custom_field' => $field['data']['nfcapsulecrm_custom_field_map'],
            );
        }

        $data['actions'][] = $new_action;
        update_option('new_action', $new_action);  // debug only
//        update_option('data_fields', $data['fields']);  // debug only
    }
// update_option('returned_data',$data);   
    return $data;
}

/**
 * Converts the 2.9 map instructions into the 3.0 key
 * 
 * Capsule uses the two-array lookup system.  Flip the lookup array to
 * generate array of the stored map instructions as key with the new value 
 * @return array Lookup array of map_instructions with $key
 */
function nfcapsulecrm_upgrade_fieldmap_lookup() {

    $standard_fields_lookup = include plugin_dir_path(__FILE__) . 'includes/Config/FieldMapLookup.php';

    $lookup_array = array_flip($standard_fields_lookup); // initialize
    $lookup_array['customField.custom'] = 'Custom (for Person)';
    /*
      foreach($standard_fields_lookup as $key=>$map_instructions){

      $lookup_array[$array['map_instructions']]=$key;

      }
     * 
     */

    return $lookup_array;
}
