<?php

/**
 * Class of static methods for validating form submission values
 */
class CapsuleValidateFields {

    public static function force_integer($value_in) {

        $value_out = intval($value_in);

        return $value_out;
    }

    public static function force_float($value_in) {

        $value_out = floatval($value_in);

        return $value_out;
    }

    public static function force_boolean($value_in) {

        $temp_value = $value_in;

        $false_values = array(
            'false',
            'FALSE',
            'unchecked'
        );

        if (in_array($temp_value, $false_values)) {
            $temp_value = FALSE;
        }

        $value_out = boolval($temp_value);

        return $value_out;
    }

    public static function limit_140_characters($value_in) {

        $value_out = substr($value_in, 0, 140);

        return $value_out;
    }

    public static function limit_60_characters($value_in) {

        $value_out = substr($value_in, 0, 60);

        return $value_out;
    }

    public static function convert_date_interval($value_in, $date_format_out = '') {

        if (strlen($date_format_out) === 0) {

            $date_format_out = NF_CapsuleCRM_Constants::DATE_FORMAT;
        }
        $date = new DateTime;

        $date_2 = new DateTime;

        $date_interval = date_interval_create_from_date_string($value_in);

        date_add($date, $date_interval);

        if ($date == $date_2) {

            $value_out = $value_in;
        } else {

            $value_out = $date->format($date_format_out);
        }

        return $value_out;
    }

    public static function format_date($value_in, $date_format_in = '') {
        
        $date_format = NF_CapsuleCRM_Constants::DATE_FORMAT;

        if (strlen($date_format_in) === 0) {

            $date_format_in = Ninja_Forms()->get_setting('date_format');
        }

        $d = DateTime::createFromFormat($date_format_in, $value_in);

        if ($d && $d->format($date_format_in) === $value_in) {

            $value_out = $d->format($date_format);      
        } else {
            
            $value_out = $value_in;
        }

        return $value_out;
    }

    /**
     * Removes non-numeric values, keeps only decimal point
     * 
     * @param mixed $value_in
     * @return 
     */
    public static function remove_non_numeric($value_in){
        
        $value_out = preg_replace('/[^0-9.]*/', "", $value_in);
        
        return $value_out;
    }
    
    /**
     * Converts 'checked' and 'unchecked' into boolean
     * 
     * @param mixed $value_in
     * @return mixed|string
     */
    public static function convert_checkbox_to_true_false_string($value_in) {
        
        $bool_lookup = array(
            'checked' => 'true',
            'unchecked' => 'false',
        );

        if (in_array($value_in, array_keys($bool_lookup))) {

            $value_out = $bool_lookup[$value_in];
        }else{
            
            $value_out = $value_in;
        }

        return $value_out;
    }

    
    /**
     * Converts array to delineated string
     * 
     * NOTE: esc_attr is removed from pre-2.9 version
     * 
     * @param mixed $value_in
     * @return mixed|string
     */
    public static function convert_array_to_comma_delineated($value_in, $delineator = ',') {

        if (is_array($value_in)) {

            $value_out = implode($delineator, $value_in);
        } else {

            $value_out = $value_in;
        }

        return $value_out;
    }

}
