<?php

class NF_CapsuleCRM_Listener {

    /**
     * Listens for GET requests with specific commands
     * 
     * Calls specific functions based on the request made; uses 
     * a switch/case so that only vetted functions are called
     */
    public static function listener() {

        /*
         * Check that Ninja_Forms is loaded, otherwise stop listening
         */
        if (!class_exists('Ninja_Forms') || !class_exists('NF_CapsuleCRM')) {

            return;
        }

        $trigger = filter_input(INPUT_GET, NF_CapsuleCRM_Constants::LISTENER_URL);
        
        $nonce = filter_input(INPUT_GET,'_wpnonce');
        
        switch ($trigger) {

            case NF_CapsuleCRM_Constants::CONNECTION_TEST:

                self::test_connection();
                break;

            case NF_CapsuleCRM_Constants::REFRESH_TOKEN_LISTENER:
                
                $verify = wp_verify_nonce($nonce, $trigger);
                
                if($verify){
                    self::generate_refresh_token();
                    break;
                }

                break;

            default:
                break;
        }
    }

    public static function generate_refresh_token() {

        $redirect = admin_url() . 'admin.php?page=nf-settings#'.NF_CapsuleCRM_Constants::ANCHOR;
        
        $obj_str = NF_CapsuleCRM_Constants::TOKEN_CLASS;
        //TODO: replace with obj_str after PHP 5.2 support is dropped
        CapsuleTokens::generate_refresh_token( $redirect);
    }

    /**
     * Test the connection with a standard request
     * 
     * TODO: add connection test
     */
    public static function test_connection() {

        $redirect = admin_url() . 'admin.php?page=nf-settings#'.NF_CapsuleCRM_Constants::ANCHOR;

        wp_redirect($redirect);
        exit;
    }

}

add_action('init', 'NF_CapsuleCRM_Listener::listener');
