<?php

/**
 * Constants for use throughout extension
 *
 */
class NF_CapsuleCRM_Constants {
    /* -------------------
     * 
     * Authorization and Connectivity
     * 
     * --------------------
     */

    /** Authorization Help stored in Ninja Settings */
    const AUTH_HELP = 'nfcapsulecrm_about_authorization';
    
    /** OAUTH Credentials key for credentials stored in wp_options */
    const OAUTH_CREDENTIALS_KEY = 'nfcapsulecrm_oauth_credentials';
    
    /** Authorization Code Key stored in Ninja Settings */
    const AUTH_CODE = 'nfcapsulecrm_auth_code';
    
    /** NF Setting for Personal Access Token use in V2 */
    const PERSONAL_ACCESS_TOKEN = 'nfcapsulecrm_personal_access_token';

    /** NF Setting for Auth token used in V1 */
    const AUTHTOKEN = 'nfcapsulecrm_authtoken';

    /** NF Setting for subdomain */
    const SUBDOMAIN = 'nfcapsulecrm_subdomain';
        
    /** Authorization level */
    const AUTHLEVEL_OPENAUTH = 'OPENAUTH';
    const AUTHLEVEL_PAT = 'PAT';
    const AUTHLEVEL_1 = 'V1';
    const AUTHLEVEL_UNAUTH = 'NOT_AUTH';

    /* ------------------
     * 
     * Listener
     * 
     * ------------------
     */

    /** URL for listening for instructions */
    const LISTENER_URL = 'nfcapsulecrm_instructions';

    /** GET value for testing API connection */
    const CONNECTION_TEST = 'test-connection';

    /** GET value for generating refresh token */
    const REFRESH_TOKEN_LISTENER = 'generate-refresh-token';


    /* ------------------
     * 
     * Processing
     * 
     * ------------------
     */

    /** Key used for "add to" action */
    const ACTION_KEY = 'addtocapsule';

    /** Key for option repeater template */
    const FIELD_MAP_REPEATER_KEY = 'capsule_field_map';
    
    /** Key for boolean check for duplicates */
    const CHECK_FOR_DUPLICATES_KEY = 'duplicate_check';

    /* ------------------
     * 
     * CLASSES
     * 
     * ------------------
     */

    /** Called at form processing to manage the processing steps */
    const PROCESS_CLASS = 'ProcessAddToCapsuleAction';

    /** Handles authorization to CRM */
    const AUTHORIZATION_CLASS = 'CapsuleAuth';
    
    /** Generates OAuth refresh and access tokens */
    const TOKEN_CLASS = 'CapsuleTokens';
    
    /** Logs communication data*/
    const COMM_LOG_CLASS = 'CapsuleCommLog';

    /** Builds request array from field map data */
    const REQUEST_ARRAY_CLASS = 'CapsuleRequestArray';
    
    /** Validates any value in and returns value out using static methods */
    const VALIDATION_CLASS = 'CapsuleValidateFields';

    /** Formats the request array into the API request structure */
    const STRUCTURED_REQUEST_CLASS = 'CapsuleStructuredRequest';

    /** Creates an entry in the CRM */
    const CREATE_CLASS = 'CapsuleCreate';

    /** Retrieves account data from the CRM */
    const RETRIEVE_CLASS = 'CapsuleRetrieve';
    
    /** Retrieves existing account data from CRM */
    const ACCOUNT_DATA_CLASS = 'CapsuleGetAccountData';

    /** Handle the response the comes back from the CRM  */
    const RESPONSE_CLASS = 'CapsuleHandleResponse';
    
    const SUPPORT_CLASS = 'NF_CapsuleCRM_Support';

    /* -------------------
     * 
     * Settings
     * 
     * -------------------- 
     */

    /** Anchor ref for quick finding CRM settings */
    const ANCHOR = 'nfcapsulecrm_settings';
    
    /** Ninja Forms setting for advanced codes */
    const ADVANCED_CODES_KEY = 'nfcapsulecrm_advanced_codes';

    /** Ninja Forms setting to display connection verification link */
    const CONNECTION_VERIFICATION = 'nfcapsulecrm_connection_verification';


    /*
     * -------------------
     * 
     * SUPPORT DATA
     * 
     * -------------------
     */

    /** wp_options key for storing support data */
    const SUPPORT_DATA = 'nfcapsulecrm_comm_data';

    /** Support data key for submission field map data */
    const REQUEST_ARRAY = 'request_array';

    /** Support data key for support messages */
    const SUPPORT_MESSAGES = 'support_messages';

    /** Support data key for structured request */
    const STRUCTURED_REQUEST = 'structured_request';

    /** Support data key for full response */
    const FULL_RESPONSE = 'most_recent_capsule_comm_result';

    /** Support data key for response summary */
    const COMM_STATUS = 'capsule_comm_status';

    /** Support data key for account data refresh link */
    const REFRESH_ACCOUNT = 'nfcapsulecrm_refresh_account_data';

    /** Support code tag where action is required */
    const ACTION_REQUIRED = '<- Action Required ->';
    
    /** Support code tag to highlight helpful information*/
    const HELPFUL_HINT = '<- Helpful Hint ->';
    
    /** Support code tag to notify of success */
    const SUCCESS = '<- Success ->';
    /*
     * -------------------
     * 
     * ACCOUNT DATA
     * 
     * -------------------
     */

    /** wp_options key for storing account data */
    const ACCOUNT_DATA = 'nfcapsulecrm_account_data';



    /* --------------------
     * 
     * API-specific settings
     * 
     * -------------------- 
     */

    /** Date format specified by the CRM */
    const DATE_FORMAT = 'Y-m-d';

    /** Base URL for all standard requests */
    const BASE_URL = '';

}
