<?php

/**
 * Receives communication from CRM, organizes, and stores it in the db
 * 
 * @author stuartlb3
 */
class CapsuleCommLog {

    /**
     * Keyed by setting, value stored in wp_options
     */
    protected $comm_data = array();

    /**
     * Indexed array of logged events used to build comm_data
     * @var array
     */
    protected $comm_log = array();

    /**
     * Logs an entry into CommLog
     * @param string $setting Setting Key for storage/display
     * @param string $module Module during which event happened
     * @param string $msg Message to be logged
     */
    public function log_entry($setting, $module, $msg) {

        $this->comm_log[] = array(
            'setting' => $setting,
            'module' => $module,
            'msg' => $msg,
        );
    }

    /**
     * Finalizes structure and writes to db
     * 
     * @param string $option_key
     */
    public function update($option_key) {

        $this->finalize_log();

        update_option($option_key, $this->comm_data);
    }

    /**
     * Keys by module where logs are stored by module
     * 
     * If the data is stored per module, add module key; if it is a single
     * entry, store directly in setting
     * 
     */
    protected function finalize_log() {

        foreach ($this->comm_log as $entry) {

            $this->comm_data[$entry['setting']][$entry['module']][] = $entry['msg'];
        }
    }

    protected function format_message($setting,$msg){
        
        $msg_out = $msg;
        
        switch($setting){
            case NF_CapsuleCRM_Constants::COMM_STATUS:
                
            break;
        }
        return $msg_out;
    }
}
