<?php

if (!defined('ABSPATH'))
    exit;

/*
 * Comm data functions are stored as a separate option to protect from being
 * overridden when saving settings.  Extract from the global var and display
 * on this page
 */

return apply_filters('nfcapsulecrm_plugin_settings', array(
    /*
      |--------------------------------------------------------------------------
      | Communication Status
      |--------------------------------------------------------------------------
     */
    NF_CapsuleCRM_Constants::COMM_STATUS => array(
        'id' => NF_CapsuleCRM_Constants::COMM_STATUS,
        'type' => 'html', // displayed only
        'label' => __('Communication Status', 'ninja-forms-capsule-crm'),
        'html' => '' // use function called at top of file to build comm status array
    ),
    NF_CapsuleCRM_Constants::AUTH_HELP => array(
        'id' => NF_CapsuleCRM_Constants::AUTH_HELP,
        'type' => 'html', // displayed only
        'label' => __('Authorization Instructions', 'ninja-forms-capsule-crm'),
        'html' => ''
    ),
    NF_CapsuleCRM_Constants::OAUTH_CREDENTIALS_KEY . '_refresh_token' => array(
        'id' => NF_CapsuleCRM_Constants::OAUTH_CREDENTIALS_KEY . '_refresh_token',
        'type' => 'html', // displayed only
        'label' => __('Refresh Token', 'ninja-forms-capsule-crm'),
        'html' => ''
    ),
    /*
      |--------------------------------------------------------------------------
      | Authorization Code
      | stored in get_option( ' ninja_forms_settings' )
      |--------------------------------------------------------------------------
     */
    NF_CapsuleCRM_Constants::AUTH_CODE => array(
        'id' => NF_CapsuleCRM_Constants::AUTH_CODE,
        'type' => 'textbox',
        'label' => __('Authorization Code', 'ninja-forms-capsule-crm'),
    ),
    /*
      |--------------------------------------------------------------------------
      | Capsule Personal Access Token
      | stored in get_option( ' ninja_forms_settings' )
      |--------------------------------------------------------------------------
     */
    NF_CapsuleCRM_Constants::PERSONAL_ACCESS_TOKEN => array(
        'id' => NF_CapsuleCRM_Constants::PERSONAL_ACCESS_TOKEN,
        'type' => 'textbox',
        'label' => __('Capsule CRM Personal Access Token', 'ninja-forms-capsule-crm'),
    ),
    /*
      |--------------------------------------------------------------------------
      | Capsule Auth Token
      | stored in get_option( ' ninja_forms_settings' )
      |--------------------------------------------------------------------------
     */
    NF_CapsuleCRM_Constants::AUTHTOKEN => array(
        'id' => NF_CapsuleCRM_Constants::AUTHTOKEN,
        'type' => 'textbox',
        'label' => __('Capsule CRM Auth Token', 'ninja-forms-capsule-crm'),
    ),
    /*
      |--------------------------------------------------------------------------
      | Capsule Subdomain
      | stored in get_option( ' ninja_forms_settings' )
      |--------------------------------------------------------------------------
     */
    NF_CapsuleCRM_Constants::SUBDOMAIN => array(
        'id' => NF_CapsuleCRM_Constants::SUBDOMAIN,
        'type' => 'textbox',
        'label' => __('Capsule CRM Subdomain', 'ninja-forms-capsule-crm'),
    ),
    /*
      'nfcapsulecrm_comm_status_divider' => array(
      'id' => 'nfcapsulecrm_comm_status_divider',
      'type' => 'html',
      'label' => '',
      'html' => '<hr /><strong>Communication Update</strong><hr />',
      ),
     * 
     */
    /*
      |--------------------------------------------------------------------------
      | Advanced Commands
      |--------------------------------------------------------------------------
     */
    NF_CapsuleCRM_Constants::ADVANCED_CODES_KEY => array(
        'id' => NF_CapsuleCRM_Constants::ADVANCED_CODES_KEY,
        'type' => 'textbox',
        'label' => __('Advanced Commands', 'ninja-forms-capsule-crm'),
    ),
    /*
      |--------------------------------------------------------------------------
      | Support
      |--------------------------------------------------------------------------
     */
    NF_CapsuleCRM_Constants::SUPPORT_MESSAGES => array(
        'id' => NF_CapsuleCRM_Constants::SUPPORT_MESSAGES,
        'type' => 'html', // displayed only
        'label' => __('Support Messages', 'ninja-forms-capsule-crm'),
        'html' => '',
    ),
    NF_CapsuleCRM_Constants::STRUCTURED_REQUEST => array(
        'id' => NF_CapsuleCRM_Constants::STRUCTURED_REQUEST,
        'type' => 'html', // displayed only
        'label' => __('Structured Request', 'ninja-forms-capsule-crm'),
        'html' => ''
    ),
    NF_CapsuleCRM_Constants::REQUEST_ARRAY => array(
        'id' => NF_CapsuleCRM_Constants::REQUEST_ARRAY,
        'type' => 'html', // displayed only
        'label' => __('Field Map Array', 'ninja-forms-capsule-crm'),
        'html' => '',
    ),
    NF_CapsuleCRM_Constants::FULL_RESPONSE => array(
        'id' => NF_CapsuleCRM_Constants::FULL_RESPONSE,
        'type' => 'html', // displayed only
        'label' => __('Most recent response from Capsule', 'ninja-forms-capsule-crm'),
        'html' => ''
    ),
    'data_dump' => array(
        'id' => 'data_dump',
        'type' => 'html', // displayed only
        'label' => __('Debug Data Dump', 'ninja-forms-capsule-crm'),
        'html' => '',
    ),
        ));
