<?php

return array(
    'organisation' => array(
        'endpoint' => '/api/organisation', // v1 endpoint
        'v2_endpoint' => '/api/v2/parties', // v2 endpoint
        'method' => 'POST',
        'request_array' => 'organisation', // the key in the structured that holds the form data for submission
        'strip_response' => '/api/party/', // used to strip location from response and keep only the newly created id
//        'new_id_key' => 'organisation_id', // the key to store the ID of the successful response
        'status_update' => __('Attempt to create a new organisation at: ', 'ninja-forms-capsule-crm'),
        'required_fields' => array(
            'type' => 'organisation',
        ),
    ),
    'person' => array(
        'endpoint' => '/api/person',
        'v2_endpoint' => '/api/v2/parties',
        'method' => 'POST',
        'request_array' => 'person', // the key in the structured request that holds the form data for submission
        'strip_response' => '/api/party/', // used to strip location from response and keep only the newly created id
        'parent' => 'organisation',
        'linking_key' => 'organisation', // key for adding parent id
//        'new_id_key' => 'person_id', // the key to store the ID of the successful response
        'status_update' => __('Attempt to create a new person at: ', 'ninja-forms-capsule-crm'),
        'required_fields' => array(
            'firstName' => 'NinjaFormsPlaceholder',
            'lastName' => 'NinjaFormsPlaceholder',
            'type' => 'person',
        ),
    ),
    'custompersonfields' => array(
        'endpoint' => '/api/party/',
        'link_to' => 'person',
        'second_endpoint' => '/customfields',
        'method' => 'PUT',
        'request_array' => 'custompersonfields',
        'status_update' => __('Attempt to create new custom field for the person at: ', 'ninja-forms-capsule-crm'),
        'required_fields' => array(),
    ),
    'opportunity' => array(
        'endpoint' => '/api/party/',
        'v2_endpoint' => '/api/v2/opportunities',
        'link_to' => 'person',
        'second_endpoint' => '/opportunity',
        'method' => 'POST',
        'request_array' => 'opportunity',
        'strip_response' => '/api/opportunity/',
        'parent' => 'person',
        'linking_key' => 'party',        
//        'new_id_key' => 'opportunity_id', // the key to store the ID of the successful response
        'status_update' => __('Attempt to create new opportunity at: ', 'ninja-forms-capsule-crm'),
        'required_fields' => array(
            'milestone' => array(
                'name' => 'Bid',
            ),
        ),
    ),
    'customopportunityfields' => array(
        'endpoint' => '/api/opportunity/',
        'link_to' => 'opportunity',
        'second_endpoint' => '/customfields',
        'method' => 'PUT',
        'request_array' => 'customopportunityfields',
        'status_update' => __('Attempt to create new custom field for the new opportunity at: ', 'ninja-forms-capsule-crm'),
        'required_fields' => array(),
    ),
    'task' => array(
        'endpoint' => '/api/party/',
        'v2_endpoint' => '/api/v2/tasks',
        'link_to' => 'person',
        'second_endpoint' => '/task',
        'method' => 'POST',
        'request_array' => 'task',
        'strip_response' => '/api/task/',
        'parent' => 'person',
        'linking_key' => 'party',
//        'new_id_key' => 'task_id',
        'status_update' => __('Attempt to create new task at: ', 'ninja-forms-capsule-crm'),
        'required_fields' => array(),
    ),
    'matched_person_merge_task' => array(
        'endpoint' => '/api/party/',
        'link_to' => 'matched_person_id',
        'second_endpoint' => '/task',
        'method' => 'POST',
        'request_array' => 'matched_person_task',
        'strip_response' => '/api/task/',
        'new_id_key' => 'matched_person_merge_task_id',
        'status_update' => __('Attempt to create new task to merge matched contacts at: ', 'ninja-forms-capsule-crm'),
        'required_fields' => array(),
    ),
    'history' => array(
        'endpoint' => '/api/party/',
        'v2_endpoint' => '/api/v2/entries',
        'link_to' => 'person',
        'second_endpoint' => '/history',
        'method' => 'POST',
        'request_array' => 'history',
        'strip_response' => '/api/history/',
//        'new_id_key' => 'history_id',
        'status_update' => __('Attempt to create new note at: ', 'ninja-forms-capsule-crm'),
        'required_fields' => array(),
    ),
    'entry' => array(
        'v2_endpoint' => '/api/v2/entries',
        'link_to' => 'person',
        'method' => 'POST',
        'parent' => 'person',
        'linking_key' => 'party',
        'required_fields' => array(
            'type'=>'note'
        ),
    ),
    'tags' => array(
        'endpoint' => '/api/party/',
        'link_to' => 'person',
        'second_endpoint' => '/tag',
        'method' => 'POST',
        'strip_response' => '/api/tag/',
        'request_array' => 'tags',
        'status_update' => __('Attempt to create new Tag at: ', 'ninja-forms-capsule-crm'),
        'required_fields' => array(),
    ),
);
