<?php

/**
 * Configures CommLog and Settings default values
 * 
 * CommLog and Settings are tightly connected since the Settings page is what
 * displays all the CommLog information
 */
return array(
    NF_CapsuleCRM_Constants::COMM_STATUS => array(
        'None' => array(
            __('No communication is currently available', 'ninja-forms-capsule-crm'),
        )
    ),
    NF_CapsuleCRM_Constants::SUPPORT_MESSAGES => array(),
    NF_CapsuleCRM_Constants::REQUEST_ARRAY => array(// key
        NF_CapsuleCRM_Constants::REQUEST_ARRAY => array(// module (use key since covers all modules)
            array(// indexed array of individual field maps (usually only one for request array)
                array(//individual field map
                    'form_field' => 'No',
                    'field_map' => 'Request',
                    'entry_type' => 'Array',
                    'custom_field' => 'Built',
                ),
            ),
        )
    ),
    NF_CapsuleCRM_Constants::STRUCTURED_REQUEST => array(// key
        NF_CapsuleCRM_Constants::STRUCTURED_REQUEST => array(//module (use key since covers all modules)
            array(// indexed array of individual structured requests (usually only one for structured request)
                array('No Module' => 'No structured request for modules'),
            ),
        ),
    ),
    'most_recent_request' => __('None', 'ninja-forms-capsule-crm'),
    'most_recent_capsule_comm_result' => __('None', 'ninja-forms-capsule-crm'),
    'advanced_codes' => '',
    'data_dump' => '',
);

