<?php

if ( !defined( 'ABSPATH' ) )
    exit;

return array(
    /*
      |--------------------------------------------------------------------------
      | Capsule Field Map
      |--------------------------------------------------------------------------
     */
    NF_CapsuleCRM_Constants::FIELD_MAP_REPEATER_KEY => array( // was field_map - check it still works
        'name' => NF_CapsuleCRM_Constants::FIELD_MAP_REPEATER_KEY,
        'type' => 'option-repeater',
        'label' => __( 'Capsule Field Map', 'ninja-forms-capsule-crm' ) . ' <a href="#" class="nf-add-new">' . __( 'Add New' ) . '</a>',
        'width' => 'full',
        'group' => 'primary',
        'tmpl_row' => 'nf-tmpl-capsule-custom-field-map-row',
        'value' => array(),
        'columns' => array(
            'form_field' => array(
                'header' => __( 'Form Field', 'ninja-forms-capsule-crm' ),
                'default' => '',
                'options' => array(),
            ),
            'field_map' => array(
                'header' => __( 'Capsule Field', 'ninja-forms-capsule-crm' ),
                'default' => '',
                'options' => array(), // created on constuction
            ),
            'entry_type' => array(
                'header' => __( 'Capsule Entry Type', 'ninja-forms-capsule-crm' ),
                'default' => '',
                'options' => array() // created on construction
            ),
            'custom_field' => array(
                'header' => __( 'Custom Capsule Field', 'ninja-forms-capsule-crm' ),
                'default' => '',
                'options' => array() // none
            ),
        ),
    ),
        /*
      |--------------------------------------------------------------------------
      | Check for Duplicates
      |--------------------------------------------------------------------------
     */
    NF_CapsuleCRM_Constants::CHECK_FOR_DUPLICATES_KEY => array(
        'name' => NF_CapsuleCRM_Constants::CHECK_FOR_DUPLICATES_KEY,
        'type' => 'toggle',
        'label' => __( 'Check for duplicates and suggest a merge in Capsule?', 'ninja-forms-capsule-crm' ),
        'width' => 'full',
        'group' => 'primary',
        'value' => FALSE,
        'help' => __( 'Do you want to check for duplicates?', 'ninja-forms-capsule-crm' ),
    ),
);


