<?php

/**
 * Retrieves account data from the CRM
 *
 */
class CapsuleRetrieve extends CapsuleCommParent {

    /**
     * Endpoint used in the retrieval request
     * @var string
     */
    protected $endpoint;
    
    /**
     * Search for existing person with given email
     * 
     * @param string $email
     */
    public function search_by_email($email) {
 
        $this->endpoint = '/api/party?email=' . $email;

        $this->post_args['headers']['Accept'] = 'application/json';

        $response = $this->make_request();

        return $response;
    }

    protected function make_request() {

        $this->post_args['method'] = 'GET';
        $response = wp_remote_post(
                $this->post_url.$this->endpoint, $this->post_args
        );

        return $response;
    }

}
