<?php

/**
 * Parent class with common methods and properties
 *
 */
abstract class CapsuleCommParent {

    /**
     * Authorization object 
     * @var object
     */
    protected $auth;

    /**
     * URL for making Create requests
     * @var string
     */
    protected $post_url;

    /**
     * POST args for API request
     * @var array
     */
    protected $post_args;

    /**
     * Raw response from the CRM
     * 
     * @var mixed
     */
    protected $raw_response;

    /**
     * 
     * @param object $auth Authorization object
     * @param array $keyed_request Structured as module =>request
     */
    function __construct($auth) {

        $this->auth = $auth;

        if (!$this->auth->is_authorized()) {

            return FALSE;
        } else {
            $this->auth_level = $this->auth->auth_level();
        }

        $this->set_default_post_args();

        $this->set_headers_array();

        $this->set_post_url();

        $this->status_update = '';
    }

    /**
     * Finalize post parameters; make wp_remote_post and return response
     * 
     * Can be protected method called by public method
     */
    abstract protected function make_request();

    /**
     * Set headers array for V1 communication
     */
    protected function set_headers_array() {

        $headers_array = array(
            'Authorization' => $this->auth->authorization_header(),
            'Content-Type' => 'application/json'
        );

        $this->post_args['headers'] = $headers_array;
    }

    /**
     * Sets the POST URL based on Auth Level
     */
    protected function set_post_url() {

        $this->post_url = $this->auth->post_url();
    }

    /**
     * Sets the default POST args
     */
    protected function set_default_post_args() {

        $ssl_verify = (bool) apply_filters('nfcapsulecrm_disable_ssl_verify', TRUE);

        $this->post_args = array(
            'timeout' => 45,
            'redirection' => 0,
            'httpversion' => '1.0',
            'sslverify' => $ssl_verify,
        );
    }

}
