<?php

/* --- NINJA FORMS CAPSULE CRM INTEGRATION --- */

class CapsuleRawRequest {

    protected $raw_request_array;

    function __construct() {

        $default_first_name = apply_filters('nfcapsulecrm_default_first_name', 'undisclosed');
        $default_last_name = apply_filters('nfcapsulecrm_default_last_name', 'undisclosed');

        $this->raw_request_array = array(
            'person' => array(// initialize person array with minimum values to ensure successful communication
                'firstName' => $default_first_name,
                'lastName' => $default_last_name
            )
        );
    }

    /* Public Methods
      -------------------- */

    public function map_field_data($user_value, $map_args = array(
        'field_map' => 'none',
        'entry_type' => 'none',
        'custom_field_map' => 'Custom Field')) {

        if ('none' == $map_args['field_map'] || '' == $user_value) {
            return;
        } // no mapping shall be done this day
        //
        //
        // modify any needed values before continuing
        switch ($map_args['field_map']) {

            case 'value.standalone.nil.nil.opportunity': // format value to remove non-numbers and decimal

                $user_value = intval(preg_replace('/[^0-9.]*/', "", $user_value));
                break;

            case 'expectedCloseDate.standalone.nil.nil.opportunity': //modify timestamp by user_value
            case 'dueDate.standalone.nil.nil.task':
                $date = new DateTime(); // get a timestamp

                date_add($date, date_interval_create_from_date_string($user_value));

                $user_value = $date->format('Y-m-d');

                break;

            default:
        }

//TODO: Move this to validation
        if (is_array($user_value)) { //multiple select is being used so convert it to a comma-delineated string
            $delineator = apply_filters('nfcapsulecrm_modify_delineator', ',');

            $user_value = esc_attr(implode($delineator, $user_value));
        }


        $mapped_field_array = explode('.', $map_args['field_map']);
        //print_r($mapped_field_array);

        $mapped_field = $mapped_field_array[0]; // set the mapped field
        $field_grouping = $mapped_field_array[1];


        if (isset($mapped_field_array[4])) { //  module is defined
            $module = $mapped_field_array[4];
        } else {
            $module = 'person'; //default to person
        }

        switch ($field_grouping) { // handle groupings
            case 'single-with-type': // entries like phone number and email can be assigned a type

                $wrap = $mapped_field_array[2]; // pull in the wrap
                $major_grouping = $mapped_field_array[3]; // pull in the major_grouping 


                $temp_array = array(
                    $mapped_field => $user_value
                );

                if ('email' == $wrap) {// determine which types are allowed for this mapped field
                    $allowed_types = array('Home', 'Work');
                } else {

                    $allowed_types = array('Home', 'Work', 'Mobile', 'Fax', 'Direct');
                    // default to phone options
                }

                if (in_array($map_args['entry_type'], $allowed_types)) {
                    // an acceptable "type" was selected so add it to the request array

                    $temp_array['type'] = $map_args['entry_type'];
                }

                $this->raw_request_array[$module][$major_grouping][$wrap][] = $temp_array;
                break;

            case 'website': //website entries include social media and repositories

                $wrap = $mapped_field_array[2]; // pull in the wrap
                $major_grouping = $mapped_field_array[3]; // pull in the major_grouping

                $temp_array = array(
                    'webService' => $mapped_field,
                    'webAddress' => $user_value
                );
                $allowed_types = array('Home', 'Work'); // the allowed types for this mapped field

                if (in_array($map_args['entry_type'], $allowed_types)) {
                    // an acceptable "type" was selected so add it to the array

                    $temp_array['type'] = $map_args['entry_type'];
                }

                $this->raw_request_array[$module][$major_grouping][$wrap][] = $temp_array;
                break;

            case 'address': // gets consolidated based on entry_type and then finalized after all fields have been processed

                $allowed_types = array('Home', 'Office', 'Postal', 'none'); // the allowed types for this mapped field

                if (in_array($map_args['entry_type'], $allowed_types)) { // an acceptable "type" was selected so add it
                    $this->raw_request_array[$module]['contacts']['address'][$map_args['entry_type']][$mapped_field] = $user_value;
                }

                break;

            case 'custom':
                /*
                 * Use entry type on custom fields when using non-text custom fields
                 */
                switch ($map_args['entry_type']) {

                    case 'date':
                        $key = 'date';
                        $user_value = $this->format_date_for_capsule($user_value);
                        break;

                    case 'boolean':
                        $key = 'boolean';
                        $user_value = $this->format_boolean_for_capsule($user_value);
                        break;

                    default:
                        $key = 'text';
                }

                $this->raw_request_array[$module]['customField'][] = array(
                    'label' => $map_args['custom_field_map'],
                    $key => $user_value
                );

                break;

            case 'majorgroup':
                $major_grouping = $mapped_field_array[3]; // pull in the major_grouping

                $this->raw_request_array[$module][$major_grouping][$mapped_field] = $user_value;

                break;

            case 'multiples': // several entries in an indexed array

                $this->raw_request_array[$module][$mapped_field][] = $user_value;

                break;

            case 'standalone':

            default:

                $this->raw_request_array[$module][$mapped_field] = $user_value;
        }
        // end switch mapped field grouping
    }

// end map_field_data

    /**
     * Finishes structuring the data array
     * Items like addresses can only be structured after all the fields have been processed
     * 
     * 
     */
    public function finalize_raw_request() {

        $this->set_address_type();
    }

    /* Internal Methods
      -------------------- */

    /**
     * Remove the temporary keys and convert associative array to indexed
     * 
     * @see function finalize_raw_request
     * 
     * @return <type>
     *
     */
    protected function set_address_type() {

        // organisation
        if (isset($this->raw_request_array['organisation']['contacts']['address'])) {

            foreach ($this->raw_request_array['organisation']['contacts']['address'] as $address_type => $address_array) {

                if ('none' != $address_array) {
                    // add type of address if it isn't 'none'
                    $address_array['type'] = $address_type;
                }
                unset($this->raw_request_array['organisation']['contacts']['address'][$address_type]);

                $this->raw_request_array['organisation']['contacts']['address'][] = $address_array;
            }
        }

        // person
        if (isset($this->raw_request_array['person']['contacts']['address'])) {

            foreach ($this->raw_request_array['person']['contacts']['address'] as $address_type => $address_array) {

                $address_array['type'] = $address_type;

                unset($this->raw_request_array['person']['contacts']['address'][$address_type]);

                $this->raw_request_array['person']['contacts']['address'][] = $address_array;
            }
        }
    }

    /**
     * Converts incoming string to Capsule's required date format
     * 
     * If the incoming string cannot be converted to a date, it defaults
     * to Unix start time 1970
     * 
     * @param string $date_string
     * @return string Formatted date string for Capsule
     */
    protected function format_date_for_capsule($date_string) {

        $old_date_timestamp = strtotime($date_string);

        $formatted_date = date('Y-m-d\TH:i:s\Z', $old_date_timestamp);

        return $formatted_date;
    }

    /**
     * Converts incoming value into either 'true' or 'false
     * 
     * @param string $incoming_user_value
     * @return string 'true' or 'false' for Capsule's boolean custom field
     */
    protected function format_boolean_for_capsule($incoming_user_value) {

        switch ($incoming_user_value) {

            case 'checked':
            case 'CHECKED':
            case 'true':
                $formatted_boolean = 'true';
                break;

            case 'unchecked':
            case 'UNCHECKED':
            case 'false':
                $formatted_boolean = 'false';
                break;
            
            default:
                $formatted_boolean = 'false';
        }

        return $formatted_boolean;
    }

    /* Gets and Sets
      -------------------- */

    /**
     * Return the raw request array for communication processing
     * 
     * 
     * @return array raw_request_array 
     *
     */
    function get_raw_request_array() {

        if (empty($this->raw_request_array)) {
            return false;
        } else {
            return $this->raw_request_array;
        }
    }

}
