<?php

if ( !defined( 'ABSPATH' ) )
    exit;

/**
 * Capsule communication object using API v1 - deprecated in 2017
 * 
 * Capsule's API v1 is being deprecated and the data constructs are changing
 * This class maintains the v1 constructs
 */
class CapsuleV1Communication {

    protected $authtoken;
    protected $raw_request_array;
    protected $command_url;
    protected $raw_response;
    protected $newly_created_id;
    protected $status_update;
    protected $form_settings_array;
    protected $existing_person_contact_ids; // builds an array of existing field entries to be overwritten
    protected $new_form_contact_map; // builds and array of the new form data to match against existing field entries
    protected $capsule_entity_array; // an array of contact entities to be checked
    protected $support_messages; // arry of any error messages for debug

    /**
     * Communicates with Capsule using API V1
     * 
     * Requires the auth token and subdomain.  Endpoint is unique to each user's
     * subdomain.  End of support is late 2017.
     * 
     * @param string $authtoken
     * @param string $subdomain
     * @param array $raw_request_array
     */
    function __construct( $authtoken = '', $subdomain = '', $raw_request_array ) {

        $this->authtoken = $authtoken;
        $this->raw_request_array = $raw_request_array;
        $this->command_url = 'https://' . $subdomain . '.capsulecrm.com';

        $this->raw_response = array();
        $this->status_update = '';
        $this->processed_response = '';
        $this->form_settings_array = array();
        $this->existing_person_contact_ids = array();
        $this->new_form_contact_map = array();
        $this->capsule_entity_array = array( 'address', 'email', 'phone', 'website' );
        $this->support_messages = array();
    }

    /* Public Methods
      -------------------- */
    public function process_form_request() {

        // organisation
        if ( isset( $this->raw_request_array[ 'organisation' ] ) ) {


            $temp_array = array( 'organisation' => $this->raw_request_array[ 'organisation' ] ); //add the json outer wrap
            $this->module_request_array[ 'organisation' ] = $temp_array;

            $this->create_new_module_entry( 'organisation' );
        }

        //person
        if ( isset( $this->raw_request_array[ 'person' ] ) ) {

            if ( isset( $this->newly_created_id[ 'organisation_id' ] ) ) {
                // an organisation was created so add the new id to person for linking the two

                $this->raw_request_array[ 'person' ] [ 'organisationId' ] = $this->newly_created_id[ 'organisation_id' ];
            }

            $temp_array = array( 'person' => $this->raw_request_array[ 'person' ] ); // add the json outer wrap
            $this->module_request_array[ 'person' ] = $temp_array;

            if ( isset( $this->form_settings_array[ 'check_for_existing_person' ] ) ) {// check if it is set
                
                /*
                 * The order is critical since NF3 uses 1 and 0 for value
                 */
                switch ($this->form_settings_array[ 'check_for_existing_person' ]) {

                    case 'do-not-check':
                    // do not check for existing person so just create a new one
                        $this->create_new_module_entry( 'person' );
                        
                        break;
                    
                    case 'suggest-merge':
                    case 1;
                        if ( $this->check_for_existing_person() ) { //  a matching person was found
                            // create a new person
                            $this->create_new_module_entry( 'person' );

                            //ADD TASK TO 'matched_person_id'
                            $this->add_merge_request_task_to_array();

                            $this->create_new_module_entry( 'matched_person_merge_task' );
                        } else {

                            // no matching person was found so create a new one   
                            $this->create_new_module_entry( 'person' );
                        }

                        break;

                    default:
                        // do not check for existing person so just create a new one
                        $this->create_new_module_entry( 'person' );

                        break;
                }
            }
        }

        // custom fields for person
        if ( isset( $this->raw_request_array[ 'customPersonFields' ] ) && isset( $this->newly_created_id[ 'person_id' ] ) ) {
            // both request array for CF and a new person are needed
            $temp_array = array( 'customFields' => $this->raw_request_array[ 'customPersonFields' ] ); //add the json outer wrap
            $this->module_request_array[ 'custompersonfields' ] = $temp_array;

            $this->create_new_module_entry( 'custompersonfields' );
        }

        // opportunity
        if ( isset( $this->raw_request_array[ 'opportunity' ] ) && isset( $this->newly_created_id[ 'person_id' ] ) ) {
            //both request array for opportunity and a new person are needed

            $temp_array = array( 'opportunity' => $this->raw_request_array[ 'opportunity' ] ); //add the json outer wrap
            $this->module_request_array[ 'opportunity' ] = $temp_array;

            $this->create_new_module_entry( 'opportunity' );
        }

        // custom fields for opportunity
        if ( isset( $this->raw_request_array[ 'customOpportunityFields' ] ) && isset( $this->newly_created_id[ 'opportunity_id' ] ) ) { //both request array for CF and a new person are needed
            $temp_array = array( 'customFields' => $this->raw_request_array[ 'customOpportunityFields' ] ); //add the json outer wrap
            $this->module_request_array[ 'customopportunityfields' ] = $temp_array;

            $this->create_new_module_entry( 'customopportunityfields' );
        }


        // task
        if ( isset( $this->raw_request_array[ 'task' ] ) && isset( $this->newly_created_id[ 'person_id' ] ) ) {
            //both request array for task and a new person are needed

            $temp_array = array( 'task' => $this->raw_request_array[ 'task' ] ); //add the json outer wrap
            $this->module_request_array[ 'task' ] = $temp_array;

            $this->create_new_module_entry( 'task' );
        }

        // note
        if ( isset( $this->raw_request_array[ 'history' ] ) && isset( $this->newly_created_id[ 'person_id' ] ) ) {
            //both request array for task and a new person are needed

            $temp_array = $this->raw_request_array[ 'history' ]; //add the json outer wrap

            $this->module_request_array[ 'history' ] = $temp_array;

            $this->create_new_module_entry( 'history' );
        }

        // tags
        if ( isset( $this->raw_request_array[ 'tags' ] ) && isset( $this->newly_created_id[ 'person_id' ] ) ) {
            //both request array for task and a new person are needed
            $temp_array = array();
            foreach ( $this->raw_request_array[ 'tags' ][ 'name' ] as $tag ) {

                $temp_array[] = urlencode($tag);
            }

            $this->module_request_array[ 'tags' ] = $temp_array; //NOT json_encoded

            $this->create_single_post_items( 'tags' );
        }
    }

    /* Internal Processing
      -------------------- */
    protected function create_new_module_entry( $module ) {

        $module_array = array(
            'organisation' => array(
                'endpoint' => '/api/organisation',
                'method' => 'POST',
                'request_array' => 'organisation', // the key in the request array that holds the form data for submission
                'strip_response' => '/api/party/', // used to strip location from response and keep only the newly created id
                'new_id_key' => 'organisation_id', // the key to store the ID of the successful response
                'status_update' => __( 'Attempt to create a new organisation at: ', 'ninja-forms-capsule-crm' ),
            ),
            'person' => array(
                'endpoint' => '/api/person',
                'method' => 'POST',
                'request_array' => 'person', // the key in the request array that holds the form data for submission
                'strip_response' => '/api/party/', // used to strip location from response and keep only the newly created id
                'new_id_key' => 'person_id', // the key to store the ID of the successful response
                'status_update' => __( 'Attempt to create a new person at: ', 'ninja-forms-capsule-crm' ),
            ),
            'custompersonfields' => array(
                'endpoint' => '/api/party/',
                'method' => 'PUT',
                'request_array' => 'custompersonfields',
                'link_to' => 'person_id',
                'second_endpoint' => '/customfields',
                'status_update' => __( 'Attempt to create new custom field for the person at: ', 'ninja-forms-capsule-crm' ),
            ),
            'opportunity' => array(
                'endpoint' => '/api/party/',
                'method' => 'POST',
                'request_array' => 'opportunity',
                'strip_response' => '/api/opportunity/',
                'new_id_key' => 'opportunity_id', // the key to store the ID of the successful response
                'link_to' => 'person_id',
                'second_endpoint' => '/opportunity',
                'status_update' => __( 'Attempt to create new opportunity at: ', 'ninja-forms-capsule-crm' ),
            ),
            'customopportunityfields' => array(
                'endpoint' => '/api/opportunity/',
                'method' => 'PUT',
                'request_array' => 'customopportunityfields',
                'link_to' => 'opportunity_id',
                'second_endpoint' => '/customfields',
                'status_update' => __( 'Attempt to create new custom field for the new opportunity at: ', 'ninja-forms-capsule-crm' ),
            ),
            'task' => array(
                'endpoint' => '/api/party/',
                'method' => 'POST',
                'request_array' => 'task',
                'strip_response' => '/api/task/',
                'new_id_key' => 'task_id',
                'link_to' => 'person_id',
                'second_endpoint' => '/task',
                'status_update' => __( 'Attempt to create new task at: ', 'ninja-forms-capsule-crm' ),
            ),
            'matched_person_merge_task' => array(
                'endpoint' => '/api/party/',
                'method' => 'POST',
                'request_array' => 'matched_person_task',
                'strip_response' => '/api/task/',
                'new_id_key' => 'matched_person_merge_task_id',
                'link_to' => 'matched_person_id',
                'second_endpoint' => '/task',
                'status_update' => __( 'Attempt to create new task to merge matched contacts at: ', 'ninja-forms-capsule-crm' ),
            ),
            'history' => array(
                'endpoint' => '/api/party/',
                'method' => 'POST',
                'request_array' => 'history',
                'strip_response' => '/api/history/',
                'new_id_key' => 'history_id',
                'link_to' => 'person_id',
                'second_endpoint' => '/history',
                'status_update' => __( 'Attempt to create new note at: ', 'ninja-forms-capsule-crm' ),
            ),
        );

        $url = $this->command_url . $module_array[ $module ][ 'endpoint' ];

        if ( isset( $module_array[ $module ][ 'second_endpoint' ] ) ) {
            // append the second endpoint, with party or opportunity in the middle
            $url .= $this->newly_created_id[ $module_array[ $module ][ 'link_to' ] ];
            $url .= $module_array[ $module ][ 'second_endpoint' ];
        }

        if ( isset( $module_array[ $module ][ 'strip_response' ] ) ) {
            // append the second endpoint, with party in the middle
            $strip_url = $this->command_url . $module_array[ $module ][ 'strip_response' ];
        }

        $headers_array = array(
            'Authorization' => 'Basic ' . base64_encode( $this->authtoken . ': X' ),
            'Content-Type' => 'application/json'
        );

        $body = json_encode( $this->module_request_array[ $module_array[ $module ][ 'request_array' ] ] );

        $args = array(
            'timeout' => 45,
            'redirection' => 0,
            'httpversion' => '1.0',
            'sslverify' => FALSE,
            'method' => $module_array[ $module ][ 'method' ],
            'headers' => $headers_array,
            'body' => $body
        );

        $create_new_module_response = wp_remote_post(
                $url, $args
        );

        $this->raw_response[] = $create_new_module_response; // add raw_response

        $response_evaluation = $this->get_response_codes( $create_new_module_response );

        if ( !$response_evaluation[ 'wp_error_flag' ] ) {

            if ( '201' == $response_evaluation[ 'response_code' ] || '200' == $response_evaluation[ 'response_code' ] ) {

                $response_evaluation[ 'response_message' ] = __( 'Successful', 'ninja-forms-capsule-crm' );

                if ( isset( $create_new_module_response[ 'headers' ][ 'location' ] ) ) {

                    $location = $create_new_module_response[ 'headers' ][ 'location' ];
                    if ( isset( $module_array[ $module ][ 'new_id_key' ] ) ) {
                        $this->newly_created_id[ $module_array[ $module ][ 'new_id_key' ] ] = str_replace( $strip_url, "", $location );
                    }
                }
            } else if ( '401' == $response_evaluation[ 'response_code' ] ) { // subdomain/auth token combination failed
                $response_evaluation[ 'response_message' ] = __( 'Unsuccessful', 'ninja-forms-capsule-crm' )
                        . '<br />'
                        . __( 'I made successful contact with Capsule, but the subdomain / authorization token was "unauthorized".', 'ninja-forms-capsule-crm' )
                        . '<br />'
                        . __( 'Please check that the values enter here match your Capsule account values exactly and then test your form again.', 'ninja-forms-capsule-crm' );
            } else if ( '400' == $response_evaluation[ 'response_code' ] ) { // Bad Request
                $response_evaluation[ 'response_message' ] = __( 'Unsuccessful', 'ninja-forms-capsule-crm' )
                        . '<br />'
                        . __( 'I made successful contact with Capsule, but received a Bad Request Failure', 'ninja-forms-capsule-crm' )
                        . '<br />'
                        . __( 'This can mean that validation failed for one of your form fields', 'ninja-forms-capsule-crm' )
                        . '<br />'
                        . __( 'Here are the details from Capsule:', 'ninja-forms-capsule-crm' )
                        . '<br />' . __( 'Error Details: ', 'ninja-forms-capsule-crm' ) . $create_new_module_response[ 'response' ][ 'message' ];
                
                /* begin NF3 enhancements - rewrite response message for simplicity*/
                if('2.9x' != NFCAPSULECRM_MODE){
                    $response_evaluation[ 'response_message' ] = __( 'Unsuccessful', 'ninja-forms-capsule-crm' )
                        . '<br />'
                        . __( 'I made successful contact with Capsule, but received a Bad Request Failure', 'ninja-forms-capsule-crm' );  
                }
                /* end  NF3 enhancements */
            } else {
                $response_evaluation[ 'response_message' ] = __( 'Unsuccessful', 'ninja-forms-capsule-crm' );
            }
        }
        // end response not wp_error

        $this->status_update .= $module_array[ $module ][ 'status_update' ]
                . $response_evaluation[ 'datetime' ]
                . __( ' was: ', 'ninja-forms-capsule-crm' )
                . $response_evaluation[ 'response_message' ] . '<br />';
        
        // NF3 uses array for support messages
        if(!empty($response_evaluation['support_messages'])){
            
            $this->support_messages= array_merge($this->support_messages,$response_evaluation['support_messages']);
        }    
    }

    protected function create_single_post_items( $module ) {// created by posting data directly to endpoint
        $module_array = array(
            'tags' => array(
                'endpoint' => '/api/party/',
                'method' => 'POST',
                'request_array' => 'tags',
                // the key in the json module request array that holds the form data for submission
                'strip_response' => '/api/tag/',
                // used to strip location from response and keep only the newly created id
                'new_id_key' => 'task_id', // the key to store the ID of the successful response
                'status_update' => __( 'Attempt to create new tag at: ', 'ninja-forms-capsule-crm' ),
                'second_endpoint' => '/tag'
            ),
        );

        $headers_array = array(
            'Authorization' => 'Basic ' . base64_encode( $this->authtoken . ': X' ),
            'Content-Type' => 'application/json'
        );

        $args = array(
            'timeout' => 45,
            'redirection' => 0,
            'httpversion' => '1.0',
            'sslverify' => FALSE,
            'method' => $module_array[ $module ][ 'method' ],
            'headers' => $headers_array,
        );

        foreach ( $this->module_request_array[ $module_array[ $module ][ 'request_array' ] ] as $body ) {

            $url = $this->command_url . $module_array[ $module ][ 'endpoint' ];

            if ( isset( $module_array[ $module ][ 'second_endpoint' ] ) ) { // append the second endpoint, with party in the middle
                $url .= $this->newly_created_id[ 'person_id' ] . $module_array[ $module ][ 'second_endpoint' ];
            }

            if ( isset( $module_array[ $module ][ 'strip_response' ] ) ) { // append the second endpoint, with party in the middle
                $strip_url = $this->command_url . $module_array[ $module ][ 'strip_response' ];
            }
            $url .= '/' . $body;

            $create_new_module_response = wp_remote_post(
                    $url, $args
            );

            $this->raw_response[] = $create_new_module_response; // add raw_response

            $response_evaluation = $this->get_response_codes( $create_new_module_response );

            if ( !$response_evaluation[ 'wp_error_flag' ] ) {

                if ( '201' == $response_evaluation[ 'response_code' ] || '200' == $response_evaluation[ 'response_code' ] ) {

                    $response_evaluation[ 'response_message' ] = __( 'Successful', 'ninja-forms-capsule-crm' );

                    if ( isset( $create_new_module_response[ 'headers' ][ 'location' ] ) ) {

                        $location = $create_new_module_response[ 'headers' ][ 'location' ];
                        $this->newly_created_id[ $module_array[ $module ][ 'new_id_key' ] ] = str_replace( $strip_url, "", $location );
                    }
                } else if ( '401' == $response_evaluation[ 'response_code' ] ) { // subdomain/auth token combination failed
                    $response_evaluation[ 'response_message' ] = __( 'Unsuccessful', 'ninja-forms-capsule-crm' )
                            . '<br />'
                            . __( 'I made successful contact with Capsule, but the subdomain / authorization token was "unauthorized".', 'ninja-forms-capsule-crm' )
                            . '<br />'
                            . __( 'Please check that the values enter here match your Capsule account values exactly and then test your form again.', 'ninja-forms-capsule-crm' );
                } else if ( '400' == $response_evaluation[ 'response_code' ] ) { // Bad Request
                    $response_evaluation[ 'response_message' ] = __( 'Unsuccessful', 'ninja-forms-capsule-crm' )
                            . '<br />'
                            . __( 'I made successful contact with Capsule, but received a Bad Request Failure', 'ninja-forms-capsule-crm' )
                            . '<br />'
                            . __( 'This can mean that validation failed for one of your form fields', 'ninja-forms-capsule-crm' )
                            . '<br />'
                            . __( 'Here are the details from Capsule:', 'ninja-forms-capsule-crm' )
                            . '<br />' . __( 'Error Details: ', 'ninja-forms-capsule-crm' ) . $create_new_module_response[ 'response' ][ 'message' ];
                } else {
                    $response_evaluation[ 'response_message' ] = __( 'Unsuccessful', 'ninja-forms-capsule-crm' );
                }
            }
            // end response not wp_error

            $this->status_update .= $module_array[ $module ][ 'status_update' ]
                    . $response_evaluation[ 'datetime' ]
                    . __( ' was: ', 'ninja-forms-capsule-crm' )
                    . $response_evaluation[ 'response_message' ] . '<br />';
        }
    }

    protected function check_for_existing_person() { // check for an existing person by searching for email address match
        // set person_id and return true if matched
        // set false if not matched
        if ( !isset( $this->module_request_array[ 'person' ] ) ) {

            return FALSE;
        }

        $person = $this->module_request_array[ 'person' ][ 'person' ];

        if ( isset( $person[ 'contacts' ][ 'email' ] ) && is_array( $person[ 'contacts' ][ 'email' ] ) ) {

            foreach ( $person[ 'contacts' ][ 'email' ] as $email_entry ) {

                if ( !isset( $email_entry[ 'emailAddress' ] ) ) {
                    break;
                } // skip if address is not set - prevent unanticipated errors

                $email_address = $email_entry[ 'emailAddress' ];

                $request_array = array(
                    'request_type' => 'check_for_person_by_email',
                    'email_address' => $email_address
                );

                $response = $this->retrieve_account_data( $request_array ); // retrieve matching persons (if any) on email

                $person_array = json_decode( $response, true );

                if ( isset( $person_array[ 'parties' ][ 'person' ][ 'id' ] ) ) {
                    // check if person is in returned array
                    // set the person_id to be updated with form data
                    $this->newly_created_id[ 'matched_person_id' ] = $person_array[ 'parties' ][ 'person' ][ 'id' ];

                    return TRUE;
                } elseif ( isset( $person_array[ 'parties' ][ 'person' ][ 0 ][ 'id' ] ) ) {

                    //in case of multiple matches
                    // set the person_id to be updated with form data
                    $this->newly_created_id[ 'matched_person_id' ] = $person_array[ 'parties' ][ 'person' ][ 0 ][ 'id' ];

                    return TRUE;
                }
            }
        }

        return FALSE;
    }

    protected function add_merge_request_task_to_array() {

        $merge_request_task_description = apply_filters( 'nfcapsulecrm_modify_merge_request_task_description', __( 'Check for possible duplicate contact', 'ninja-forms-capsule-crm' ) );

        $merge_request_task_detail = apply_filters( 'nfcapsulecrm_modify_merge_request_task_detail', __( 'A new form submission uses the same email as an existing contact.  Please review the two contacts and merge if necessary. ', 'ninja-forms-capsule-crm' ) );


        $merge_request_task_due_date_interval = apply_filters( 'nfcapsulecrm_modify_merge_request_task_due_date', __( '0 days', 'ninja-forms-capsule-crm' ) );


        $date = new DateTime(); // get a timestamp

        date_add( $date, date_interval_create_from_date_string( $merge_request_task_due_date_interval ) );

        $merge_request_task_due_date = $date->format( 'Y-m-d' );

        $this->module_request_array[ 'matched_person_task' ][ 'task' ] = array(
            'description' => $merge_request_task_description,
            'detail' => $merge_request_task_detail,
            'dueDate' => $merge_request_task_due_date
        );
    }

    protected function retrieve_account_data( $request = array( 'request_type' => '', 'email_address' => '' ) ) {
        // if successfully retrieved, return the account data requested, if fails, return FALSE

        if ( !isset( $request[ 'request_type' ] ) ) {
            return FALSE;
        }

        $module_array = array(
            'check_for_person_by_email' => array(
                'endpoint' => '/api/party',
                'method' => 'GET',
                'filter' => '?limit=1&email=' . $request[ 'email_address' ] // set limit to first person retrieved and match on email
            ),
        );

        $headers_array = array(
            'Authorization' => 'Basic ' . base64_encode( $this->authtoken . ': X' ),
            'Content-Type' => 'application/json',
            'Accept' => 'application/json'
        );

        $args = array(
            'timeout' => 45,
            'redirection' => 0,
            'httpversion' => '1.0',
            'sslverify' => FALSE,
            'method' => $module_array[ $request[ 'request_type' ] ][ 'method' ],
            'headers' => $headers_array,
        );

        $url = $this->command_url . $module_array[ $request[ 'request_type' ] ][ 'endpoint' ];

        if ( isset( $module_array[ $request[ 'request_type' ] ][ 'filter' ] ) ) {

            $url .= $module_array[ $request[ 'request_type' ] ][ 'filter' ];
        }


        $raw_account_data = wp_remote_post(
                $url, $args
        );

        $response_code = $this->get_response_codes( $raw_account_data );

        if ( '200' == $response_code[ 'response_code' ] ) {

            $account_data = $raw_account_data[ 'body' ];

            return $account_data;
        } else {

            return FALSE;
        }
    }

    protected function get_response_codes( $raw_response ) {

        if ( is_wp_error( $raw_response ) ) {

            $response_codes = array(
                'wp_error_flag' => true,
                'datetime' => date( DATE_COOKIE ),
                'response_code' => $raw_response->get_error_code(),
                'response_message' => $raw_response->get_error_message()
            );
        } else {
            $response_codes = array(
                'wp_error_flag' => false,
                'datetime' => $raw_response[ 'headers' ][ 'date' ],
                'response_code' => $raw_response[ 'response' ][ 'code' ],
                'support_messages' => array(),
            );
        }
        /*
         * Begin NF3 Enhancements
         */

        /*
         * When there is a 400 or 401 code, extract as much info as practical
         * 
         * 
         */
        $body = json_decode( $raw_response[ 'body' ], true );
        $response =/* json_decode( */$raw_response[ 'response' ]/*, true )*/; // raw response 

        if ( '401' == $response_codes[ 'response_code' ] || '400' == $response_codes[ 'response_code' ] ) {

            /*
             * Some errors are returned as an array
             */
            if ( is_array( $body ) ) {

                if ( isset( $body[ 'message' ] ) ) {

                    $response_codes[ 'support_messages' ][] = $body[ 'message' ];
                }elseif(0< strlen( $body)){
                    
                    $response_codes[ 'support_messages' ][] = wp_strip_all_tags($body);
                }

                if ( isset( $body[ 'errors' ] ) ) {

                    foreach ( $body[ 'errors' ] as $error ) {
                        $response_codes[ 'support_messages' ][] = $error[ 'field' ] . ' ' . $error[ 'message' ];
                    }
                }
            }else{
                /*
                 * If body is not an array, there may still be html formatted message
                 */
                if(0<  strlen( $body)){
                    
                    $response_codes[ 'support_messages' ][] = wp_strip_all_tags($body);
                }
                
            }
        }
        /*
         * End NF3 Enhancements
         */
        return $response_codes;
    }

    /*
      Gets and Sets
      -------------------- */
    public function get_raw_response() {

        if ( empty( $this->raw_response ) ) {
            return false;
        } else {
            return $this->raw_response;
        }
    }

    public function get_status_update() {

        if ( empty( $this->status_update ) ) {
            return false;
        } else {
            return $this->status_update;
        }
    }

    public function get_support_messages(){
        
        if ( empty( $this->support_messages ) ) {
            return false;
        } else {
            return $this->support_messages;
        }    
    }
    public function set_form_settings( $settings_array ) {

        $this->form_settings_array = $settings_array;
    }

}
