<?php

/**
 * Functionality from Advanced Commands in the Settings section
 */
/*
 * If user does not want admin level to be able to set advanced commands,
 * he/she can define a constant in functions.php to skip all functionality
 * in this area
 */

add_action('init', 'nfcapsulecrm_advanced_command_filters');

/**
 * Cycles through advanced commands and sets filter values
 * 
 * @return type
 */
function nfcapsulecrm_advanced_command_filters() {

    if (defined('DISABLE_CAPSULE_ADVANCED_COMMANDS')) {

        return;
    }

    $advanced_codes_array = nfcapsulecrm_extract_advanced_codes();

    $filters = NF_CapsuleCRM::config('AdvancedCommandFilters');

    foreach ($advanced_codes_array as $code) {

        if (array_key_exists($code, $filters)) {
            
            $filter = $filters[$code]['filter'];
            $callback = $filters[$code]['filter_callback'];
                          
            add_filter($filter, $callback);

        }
    }
}

/**
 * Returns TRUE boolean for use in filter callbacks
 * 
 * @return TRUE
 */
function nfcapsulecrm_return_true(){
    
    return TRUE;
}
