<?php

if (!defined('ABSPATH') || !class_exists('NF_Abstracts_Action'))
    exit;

final class NF_CapsuleCRM_Actions_AddToCapsule extends NF_Abstracts_Action {

    protected $_name = 'addtocapsule'; // child CRM
    protected $_tags = array();
    protected $_timing = 'normal';
    protected $_priority = '10';

    /**
     * The field data from the form submission needed for building the field map array
     * @var array
     */
    protected $fields_to_extract;

    /**
     * The array of mapping data to be built into the request object
     * 
     * @var array
     */
    protected $field_map_array;

    /**
     * The lookup array to convert readable field map to programmtic field map
     * @var array
     */
    protected $field_map_lookup;

    /**
     *
     * @var array Array of credentials with error and support messages
     */
    protected $validated_credentials;

    public function __construct() {
        parent::__construct();

        $this->_nicename = __('Add To Capsule', 'ninja-forms-capsule-crm');

        $this->fields_to_extract = NF_CapsuleCRM::config('FieldsToExtract');
        $this->field_map_lookup = NF_CapsuleCRM()->get_field_map_lookup();

        // initialize the action settings
        add_action('admin_init', array($this, 'init_settings'));

        // create the output template
        add_action('ninja_forms_builder_templates', array($this, 'builder_templates'));
    }

    public function save($action_settings) {

        $keyed_action_settings = $action_settings[NF_CapsuleCRM_Constants::FIELD_MAP_REPEATER_KEY];

        // ensure field map is array and is not empty before modifying
        if (!is_array($keyed_action_settings) || empty($keyed_action_settings)) {

            return $action_settings;
        }

        $scrubbed_field_map = $this->scrub_action_settings($keyed_action_settings);

        $action_settings['salesforce_field_map'] = $scrubbed_field_map;

        return $action_settings;
    }

    /**
     * Process the form submission
     * 
     * @param array $action_settings
     * @param integer $form_id
     * @param array $data
     * @return array
     */
    public function process($action_settings, $form_id, $data) {

        $this->load_classes(); // load processing classes

        $this->select_processing_method($action_settings);

        return $data;
    }

    /**
     * Selects and calls the specified Process Action Class
     * 
     * By default, the call to the class that processes the action is hard-coded
     * 
     * If alternate processing is enabled, the call is done through an
     * action hook, enabling removal of the default class and replacing it
     * with another class
     * 
     * @param array $action_settings
     */
    protected function select_processing_method($action_settings) {

        $advanced_codes_array = NF_CapsuleCRM_Functions::extract_advanced_codes();

        if (!in_array('enable_alternate_processing', $advanced_codes_array)) {

            $str_obj = NF_CapsuleCRM_Constants::PROCESS_CLASS;
            //TODO: replace with str_obj after PHP 5.2 support is dropped
            new ProcessAddToCapsuleAction($action_settings);
        } else {

            do_action('nfcapsulecrm_process_capsule_action', $action_settings);
        }

        return $data;
    }

    public function builder_templates() {
        NF_CapsuleCRM::template('custom-field-map-row.html');
    }

    public function init_settings() {

        // bring in configured settings
        $settings = NF_CapsuleCRM::config('ActionFieldMapSettings');
        $this->_settings = array_merge($this->_settings, $settings);

        // set dropdown for Capsule fields from config file
        $fieldmap_dropdown = NF_CapsuleCRM_Functions::build_field_map_dropdown($this->field_map_lookup);

        // ensure top level array matches ActionFieldMapSettings
        $this->_settings[NF_CapsuleCRM_Constants::FIELD_MAP_REPEATER_KEY]['columns']['field_map']['options'] = $fieldmap_dropdown;

        // set dropdown for Capsule entry type from config file
        $entry_type = NF_CapsuleCRM::config('EntryType');
        $this->_settings[NF_CapsuleCRM_Constants::FIELD_MAP_REPEATER_KEY]['columns']['entry_type']['options'] = $entry_type;
    }

        /**
     * Remove unused dropdown options stored in specific action settings key
     * @param type $keyed_action_settings
     */
    protected function scrub_action_settings($keyed_action_settings) {

        foreach ($keyed_action_settings as &$field_map_entry) {

            $field_map_entry['options']['field_map'] = array();
            $field_map_entry['settingModel']['columns']['field_map']['options'] = array();

            $field_map_entry['options']['entry_type'] = array();
            $field_map_entry['settingModel']['columns']['entry_type']['options'] = array();
        }

        return $keyed_action_settings;
    }
    
    protected function load_classes() {

        NF_CapsuleCRM::file_include('Comm', 'CommParent');
        NF_CapsuleCRM::file_include('Comm', 'ProcessAction');
        NF_CapsuleCRM::file_include('Comm', 'RequestArray');
        NF_CapsuleCRM::file_include('Comm', 'StructuredRequest');
        NF_CapsuleCRM::file_include('Comm', 'StructuredRequest_v1');
        NF_CapsuleCRM::file_include('Comm', 'Create');
        NF_CapsuleCRM::file_include('Comm', 'Create_v1');
        NF_CapsuleCRM::file_include('Comm', 'Retrieve');
        NF_CapsuleCRM::file_include('Comm', 'HandleResponse');
    }

}

add_action('nfcapsulecrm_process_capsule_action', 'nfcapsulecrm_default_process_capsule_action', 9, 1);

/**
 * Calls the default Process Action class through an action hook
 * @param array $action_settings
 */
function nfcapsulecrm_default_process_capsule_action($action_settings) {

    $str_obj = NF_CapsuleCRM_Constants::PROCESS_CLASS;
    // TODO: replace with str_obj after PHP 5.2 support is dropped
    new ProcessAddToCapsuleAction($action_settings);
}
