<?php

/*
  Name: Ninja Forms - Capsule CRM for pre-3.0
  URI: http://lb3computingsolutions.com
 */

/* ----------
  INCLUDES
  ---------------------------------------------------------------------------------------------------------- */


/* ----------
  Create options pages and settings required
  ------ */

include_once( NF2CAPSULECRM_PLUGIN_DIR . '/deprecated/includes/settings-deprecated.php');
include_once( NF2CAPSULECRM_PLUGIN_DIR . '/deprecated/includes/form-settings-deprecated.php');

/* ----------
  Create field options for mapping to Capsule
  ----- */

include_once( NF2CAPSULECRM_PLUGIN_DIR . '/deprecated/includes/field-registration-deprecated.php');


/* ----------
  Process form data and build xml needed for communication with Capsule
  ----- */

include_once( NF2CAPSULECRM_PLUGIN_DIR . '/deprecated/includes/form-processing-deprecated.php');


/* ----------
  Create Raw Request
  ----- */

include_once( NF2CAPSULECRM_PLUGIN_DIR . 'includes/Comm/CapsuleRawRequest.php');

/* ----------
  Communicate with Capsule via API
  ----- */
include_once( NF2CAPSULECRM_PLUGIN_DIR . 'includes/Comm/CapsuleCommunication_1.php');


/* ----------
  Include shared functions
  ----- */
include_once( NF2CAPSULECRM_PLUGIN_DIR . 'includes/Admin/DeprecatedFunctions.php');


/* ----------
 * Load the global variables
 ----- */
nfcapsule_load_globals();


/* ----------
  LICENSING
  -------------------------------------------------------------------------------------------------------------- */

add_action( 'admin_init', 'nfcapsulecrm_extension_setup_license' );

function nfcapsulecrm_extension_setup_license() {
    if ( class_exists( 'NF_Extension_Updater' ) ) {
        $NF_Extension_Updater = new NF_Extension_Updater( 'Capsule CRM', NF2CAPSULECRM_VERSION, 'Stuart Sequeira', __FILE__ );
    }
}

/* ----------
  LANGUAGE
  -------------------------------------------------------------------------------------------------------------- */

add_action( 'plugins_loaded', 'nfcapsulecrm_extension_load_lang' );

function nfcapsulecrm_extension_load_lang() {

    /** Set our unique textdomain string */
    $textdomain = 'ninja-forms-capsule-crm';

    /** The 'plugin_locale' filter is also used by default in load_plugin_textdomain() */
    $locale = apply_filters( 'plugin_locale', get_locale(), $textdomain );

    /** Set filter for WordPress languages directory */
    $wp_lang_dir = apply_filters(
            'ninja_forms_wp_lang_dir', WP_LANG_DIR . '/' . basename( dirname( __FILE__ ) ) . '/' . $textdomain . '-' . $locale . '.mo'
    );

    /** Translations: First, look in WordPress' "languages" folder = custom & update-secure! */
    load_textdomain( $textdomain, $wp_lang_dir );

    /** Translations: Secondly, look in plugin's "lang" folder = default */
    $plugin_dir = basename( dirname( __FILE__ ) );
    $lang_dir = apply_filters( 'nfcapsulecrm_extension_lang_dir', $plugin_dir . '/lang/' );
    load_plugin_textdomain( $textdomain, FALSE, $lang_dir );
}

/* ----------
  HOOK INTO THE FLOW
  -------------------------------------------------------------------------------------------------- */

add_action( 'init', 'nfcapsulecrm_frontend_hook' );

function nfcapsulecrm_frontend_hook() {

    add_action( 'ninja_forms_post_process', 'nfcapsulecrm_process_form' ); // form-processing.php
}



