<?php
/* --- NINJA FORMS CAPSULE CRM INTEGRATION --- */


/* ----------
  CREATE OPTIONS PAGE AND GET SETTINGS FOR SITE-WIDE VALUES
  ------------------------------------------------------------------------------------------------------------ */

/* ----------
  Create options page location
  ----- */

add_action( 'admin_menu', 'nfcapsulecrm_create_options_page_location', 100 );

function nfcapsulecrm_create_options_page_location() {

    add_submenu_page(
            'ninja-forms', //parent slug
            __( 'Capsule CRM Settings', 'ninja-forms-capsule-crm' ), //page title
            __( 'Capsule CRM Settings', 'ninja-forms-capsule-crm' ), //menu title
            'manage_options', //capability
            'nfcapsulecrm-site-options', //menu-slug
            'nfcapsulecrm_site_options_display_page' //display function
    );
}

// end nfcapsulecrm_create_options_page_location


/* ----------
  Output the html for the options page
  ----- */

function nfcapsulecrm_site_options_display_page() {

    global $nfcapsulecrm_site_options;
    ?>
    <div class="wrap">
        <?php screen_icon( 'options-general' ); ?>
        <h2><?php _e( 'Ninja Forms Capsule CRM Settings', 'ninja-forms-capsule-crm' ); ?></h2>

        <form method="post" action="options.php" class="nfcapsulecrm_site_options_form">

            <?php
            // whitelist our variables and output the settings sections
            settings_fields( 'nfcapsulecrm-site-options' ); // whitelists all variables registered to this slug
            do_settings_sections( 'nfcapsulecrm-site-options-section' ); // outputs all sections added via add_settings_section
            // output the communication status
            echo nfcapsulecrm_output_comm_status();
            ?>
            <p class="submit">
                <input type="submit" class="button-primary" value="<?php _e( 'Save Options', 'ninja-forms-capsule-crm' ); ?>" />
            </p>			
        </form>
    </div><!--end .wrap-->
    <?php
}

//end nfcapsulecrm_site_options_display_page


/* ----------
  CREATE OPTIONS FIELD AND SECTION
  Insert these options onto a menu page
  The menu page is a custom settings page created under the Ninja Forms main menu page
  ----- */

add_action( 'admin_init', 'nfcapsulecrm_create_sitewide_settings' );

function nfcapsulecrm_create_sitewide_settings() {

    /* --- register setting --- */
    $settings_fields = 'nfcapsulecrm-site-options';
    $variable_to_register = 'nfcapsulecrm_settings';

    register_setting( $settings_fields, $variable_to_register, 'nfcapsulecrm_validate_settings' ); // registers our setting to allow it to appear in a given form	


    /* --- Add Settings Section --- */

    $section_id = 'nfcapsulecrm_site_section'; //id for our section
    $section_title = __( 'Ninja Forms Capsule CRM Connection Settings', 'ninja-forms-capsule-crm' ); // about our section
    $section_output_function = 'nfcapsulecrm_section_output'; //

    $do_settings_section = 'nfcapsulecrm-site-options-section'; //on which page should our new section go

    add_settings_section(
            $section_id
            , $section_title
            , $section_output_function
            , $do_settings_section
    );


    /* --- Create array to add each sitewide option --- */

    $options_array = array();

    $options_array[ 'authtoken' ] = array(
        'field_id' => 'nfcapsulecrm_authtoken',
        'field_title' => __( 'Capsule CRM Auth Token', 'ninja-forms-capsule-crm' )
        , 'field_output_function' => 'nfcapsulecrm_authtoken_field_output'
    );

    $options_array[ 'subdomain' ] = array(
        'field_id' => 'nfcapsulecrm_subdomain',
        'field_title' => __( 'Capsule CRM Subdomain', 'ninja-forms-capsule-crm' )
        , 'field_output_function' => 'nfcapsulecrm_subdomain_field_output'
    );

    $options_array[ 'display_raw_comm' ] = array(
        'field_id' => 'nfcapsulecrm_display_raw_comm',
        'field_title' => __( 'Display the Raw Communication Data?', 'ninja-forms-capsule-crm' )
        , 'field_output_function' => 'nfcapsulecrm_display_raw_comm_field_output'
    );


    /* --- Loop through each option array to add a field to a do_settings_section --- */

    foreach ( $options_array as $option ) {

        add_settings_field(
                $option[ 'field_id' ]//unique id for field
                , $option[ 'field_title' ]//field title
                , $option[ 'field_output_function' ]//function callback
                , $do_settings_section //on which page should our new field go
                , $section_id //in which settings section should our new field go
                //,$section='default'
                //,$args=array()
        );
    }
}

// end nfcapsulecrm_create_sitewide_settings


/* ----------
  Output the settings section tagline
  ----- */

function nfcapsulecrm_section_output() {

    echo __( 'Please enter your Capsule CRM authorization token and your subdomain.', 'ninja-forms-capsule-crm' ) . ' <br />';
    echo __( 'Hint: you log into Capsule at: YourSubDomain.capsulecrm.com', 'ninja-forms-capsule-crm' );
}

// end nfcapsulecrm_section_output


/* ----------
  Output the authtoken form html
  ----- */

function nfcapsulecrm_authtoken_field_output() {

    global $nfcapsulecrm_site_options;

    ob_start();
    ?>

    <input 
        id="nfcapsulecrm_authtoken"
        name="nfcapsulecrm_settings[nfcapsulecrm_authtoken]"
        size = "50"
        type="text" 
        value = "<?php
        if ( isset( $nfcapsulecrm_site_options[ 'nfcapsulecrm_authtoken' ] ) ) {
            echo $nfcapsulecrm_site_options[ 'nfcapsulecrm_authtoken' ];
        }
        ?>" 
        />

    <?php
    echo ob_get_clean();
}

//end nfcapsulecrm_authtoken_field_output


/* ----------
  Output the subdomain form html
  ----- */

function nfcapsulecrm_subdomain_field_output() {

    global $nfcapsulecrm_site_options;

    ob_start();
    ?>

    <input 
        id="nfcapsulecrm_subdomain"
        name="nfcapsulecrm_settings[nfcapsulecrm_subdomain]"
        size = "50"
        type="text" 
        value = "<?php
    if ( isset( $nfcapsulecrm_site_options[ 'nfcapsulecrm_subdomain' ] ) ) {
        echo $nfcapsulecrm_site_options[ 'nfcapsulecrm_subdomain' ];
    }
    ?>" 
        />

    <?php
    echo ob_get_clean();
}

//end nfcapsulecrm_subdomain_field_output

/* ----------
  Output the display raw comm form html
  Also display the comm strings if set to "Yes"
  ----- */

function nfcapsulecrm_display_raw_comm_field_output() {

    global $nfcapsulecrm_site_options;


    if ( isset( $nfcapsulecrm_site_options[ 'nfcapsulecrm_display_raw_comm' ] ) ) {

        $checked = $nfcapsulecrm_site_options[ 'nfcapsulecrm_display_raw_comm' ];
    } else {
        $checked = 'no';
    }


    ob_start();
    ?>

    <input 
        id="nfcapsulecrm_display_raw_comm-yes"
        name="nfcapsulecrm_settings[nfcapsulecrm_display_raw_comm]"
        type="radio" 
        value = "TRUE" 
    <?php checked( $checked, 'TRUE', true ); ?>
        />
    Yes <br />

    <input 
        id="nfcapsulecrm_display_raw_comm-no"
        name="nfcapsulecrm_settings[nfcapsulecrm_display_raw_comm]"
        type="radio" 
        value = "FALSE" 
    <?php checked( $checked, 'FALSE', true ); ?>
        />
    No <br />


    <?php
    echo ob_get_clean();
}

//end nfcapsulecrm_subdomain_field_output

/* ----------
  Validate the authtoken value before saving to database
  ----- */

function nfcapsulecrm_validate_settings( $input ) {

    $output = array();

    foreach ( $input as $key => $value ) {

        if ( isset( $input[ $key ] ) ) {

            $output[ $key ] = strip_tags( stripslashes( $input[ $key ] ) );
        }// endif
    } //end foreach

    return apply_filters( 'nfcapsulecrm_validate_settings', $output, $input );
}

// end nfcapsulecrm_validate_settings


/* ----------
  Create HTML for communication status

  - includes Communication Status and the raw xml string and the raw Capsule response
  - the xml string and response is only displayed if "display raw communication" is set to true

  ----- */

function nfcapsulecrm_output_comm_status() {

    global $nfcapsulecrm_site_options;
    global $nfcapsulecrm_comm_data;

    if ( isset( $nfcapsulecrm_comm_data[ 'capsule_comm_status' ] ) ) {

        $capsule_comm_status = $nfcapsulecrm_comm_data[ 'capsule_comm_status' ];
    } else {
        $capsule_comm_status = apply_filters( 'nfcapsulecrm_modify_capsule_comm_status_default', "No communication has been detected.  Please test using your created form." );
    }


    if ( isset( $nfcapsulecrm_site_options[ 'nfcapsulecrm_display_raw_comm' ] ) ) {

        $display_raw_comm = $nfcapsulecrm_site_options[ 'nfcapsulecrm_display_raw_comm' ] == "TRUE";
    } else {
        $display_raw_comm = FALSE;
    }


    if ( isset( $nfcapsulecrm_comm_data[ 'most_recent_capsule_xml_string' ] ) ) {

        $most_recent_string_sent = str_replace( array( '<', '>' ), array( '(', ')' ), $nfcapsulecrm_comm_data[ 'most_recent_capsule_xml_string' ] );
    } else {
        $most_recent_string_sent = __( 'None', 'ninja-forms-capsule-crm' );
    }

    if ( isset( $nfcapsulecrm_comm_data[ 'most_recent_capsule_comm_result' ] ) ) {

        $most_recent_capsule_response = serialize( $nfcapsulecrm_comm_data[ 'most_recent_capsule_comm_result' ] );
    } else {
        $most_recent_capsule_response = __( 'None', 'ninja-forms-capsule-crm' );
    }


    ob_start();
    ?>

    <table class="form-table">
        <tbody>
            <tr valign="top">
                <th scope="row"><?php _e( 'Communication Status', 'ninja-forms-capsule-crm' ); ?></th>
                <td>

            <?php echo $capsule_comm_status; ?>

                </td>
            </tr>

                    <?php if ( $display_raw_comm ) { ?>		
                <tr valign="top">
                    <th scope="row"><?php _e( 'Most recent request array sent to Capsule', 'ninja-forms-capsule-crm' ); ?></th>
                    <td>

        <?php echo $most_recent_string_sent; ?>

                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e( 'Most recent response from Capsule', 'ninja-forms-capsule-crm' ); ?></th>
                    <td>

                <?php echo esc_html( $most_recent_capsule_response ); ?>

                    </td>
                </tr>			
    <?php } // end if $display_raw_com  ?>

        </tbody>
    </table>

    <?php
    $comm_status_string = ob_get_clean();

    return $comm_status_string;
}

// end nfcapsulecrm_output_comm_status


