<?php
/* --- NINJA FORMS CAPSULE CRM INTEGRATION --- */

/* ----------
  FORM-SPECIFIC OPTIONS
  ------------------------------------------------------------------------------------------------------------------------ */

/* ----------
  Create the form-specific options
  ----- */

/* --- first, hook into the flow --- */
add_action( 'admin_init', 'nfcapsulecrm_admin_hook', 12 );

function nfcapsulecrm_admin_hook() {

    nfcapsulecrm_create_field_options();
}

/* ----------
  Create the form specific options
  ----- */

function nfcapsulecrm_create_field_options() {

    global $nfcapsulecrm_site_options;

    if ( !isset( $nfcapsulecrm_site_options[ 'nfcapsulecrm-add-to-leads' ] ) ) {
        $nfcapsulecrm_site_options[ 'nfcapsulecrm-add-to-leads' ] = false;
    }

    if ( !isset( $nfcapsulecrm_site_options[ 'nfcapsulecrm-check-for-existing-person' ] ) ) {
        $nfcapsulecrm_site_options[ 'nfcapsulecrm-check-for-existing-person' ] = false;
    }

    //Add given form to leads?
    $args = array(
        'page' => 'ninja-forms',
        'tab' => 'form_settings',
        'slug' => 'nfcapsulecrm_settings',
        'title' => __( 'Capsule CRM Settings', 'ninja-forms-capsule-crm' ),
        'settings' => array(
            array(
                'name' => 'nfcapsulecrm-add-to-leads',
                'type' => 'checkbox',
                'label' => __( 'Add to Capsule Leads', 'ninja-forms-capsule-crm' ),
                'desc' => __( 'Do you want this form data added as a Capsule CRM lead?', 'ninja-forms-capsule-crm' ),
                'default_value' => $nfcapsulecrm_site_options[ 'nfcapsulecrm-add-to-leads' ],
            ),
            array(
                'name' => 'nfcapsulecrm-check-for-existing-person',
                'type' => 'radio',
                'label' => __( 'Check for existing person?', 'ninja-forms-capsule-crm' ),
                'desc' => __( 'Do you want to check for an existing person by comparing email address and create a new contact and a task to manually verify and merge?', 'ninja-forms-capsule-crm' ),
                'default_value' => $nfcapsulecrm_site_options[ 'nfcapsulecrm-check-for-existing-person' ],
                'options' => array(
                    array( 
                        'name' => __('NO, do not check for existing person', 'ninja-forms-capsule-crm' ), 
                        'value' => 'do-not-check' ),
                    array( 
                        'name' => __('YES, check for existing person and suggest a merge', 'ninja-forms-capsule-crm' ), 
                        'value' => 'suggest-merge' ),
                   
                )
            ),
          
        )
    );

    if ( function_exists( 'ninja_forms_register_tab_metabox_options' ) ) {

        ninja_forms_register_tab_metabox( $args );
    }
}

//end nfcapsulecrm_create_field_options