<?php

/* --- NINJA FORMS CAPSULE CRM INTEGRATION --- */


/* ----------
  PROCESS FORM DATA
  - build xml file from form
  - validate form data if necessary
  - log or display results from API
  ------------------------------------------------------------------------------------------------------------ */



/* ----------
  Process Insert Form Data as Lead
  ----- */

function nfcapsulecrm_process_form() {

    global $ninja_forms_processing;
    global $nfcapsulecrm_comm_data;
    global $nfcapsulecrm_site_options;

    // Check if the form should be inserted as Capsule lead

    $the_droids = $ninja_forms_processing->get_form_setting( 'nfcapsulecrm-add-to-leads' );
    if ( !$the_droids ) {
        return;
    } ///this is not the form you're looking for	

    $error_flag = FALSE;

    // ensure there is a value for the authtoken
    if ( !isset( $nfcapsulecrm_site_options[ 'nfcapsulecrm_authtoken' ] ) || ('' == $nfcapsulecrm_site_options[ 'nfcapsulecrm_authtoken' ] ) ) {

        $nfcapsulecrm_comm_data[ 'capsule_comm_status' ] = __( 'No authorization token was entered before the last communication attempt.', 'ninja-forms-capsule-crm' )
                . '<br />';

        $error_flag = TRUE;
    }

    // ensure that there is a value for the subdomain
    if ( !isset( $nfcapsulecrm_site_options[ 'nfcapsulecrm_subdomain' ] ) || ( '' == $nfcapsulecrm_site_options[ 'nfcapsulecrm_subdomain' ]) ) {

        $temp_string = __( 'No subdomain was entered before the last communication attempt.', 'ninja-forms-capsule-crm' ) . '<br />';

        if ( $error_flag ) { // authtoken already started error message so append it
            $nfcapsulecrm_comm_data[ 'capsule_comm_status' ] .= $temp_string;
        } else { // no previous error so overwrite previous comm status
            $nfcapsulecrm_comm_data[ 'capsule_comm_status' ] = $temp_string;
        }

        $error_flag = TRUE;
    }

    // one of the two checks failed, do not attempt communication.  Update comm_status and return
    if ( $error_flag ) {

        $temp_string = '<br />'
                . __( 'Please enter the missing information and test your form again.', 'ninja-forms-capsule-crm' );

        $nfcapsulecrm_comm_data[ 'capsule_comm_status' ] .= $temp_string;

        update_option( 'nfcapsulecrm_comm_data', $nfcapsulecrm_comm_data );
        return false;
    }


    // Begin processing the data
    //$request_object = new CapsuleRawRequest;
    // communicate with Capsule CRM
    if ( class_exists( 'CapsuleRawRequestPlus' ) ) {
        $request_object = new CapsuleRawRequestPlus;
    } else {
        $request_object = new CapsuleRawRequest;
    }



    $field_array = $ninja_forms_processing->get_all_fields();


    foreach ( $field_array as $field_id => $user_value ) { //cycle through each submitted field
        $field = ninja_forms_get_field_by_id( $field_id );

        if ( isset( $field[ 'data' ][ 'nfcapsulecrm_field_map' ] ) ) {

            $map_args[ 'field_map' ] = nfcapsulecrm_maintain_backwards_mapping_compatability( $field[ 'data' ][ 'nfcapsulecrm_field_map' ] );
        } else {

            $map_args[ 'field_map' ] = 'none';
        }

        // set the $entry_type variable
        if ( isset( $field[ 'data' ][ 'nfcapsulecrm_entry_type' ] ) ) {

            $map_args[ 'entry_type' ] = $field[ 'data' ][ 'nfcapsulecrm_entry_type' ]; // entry type includes Work, Mobile, Home etc
        } else {
            $map_args[ 'entry_type' ] = 'none';
        }


        // set the $custom_field_map variable
        // this is the custom field to which the form field will map
        if ( isset( $field[ 'data' ][ 'nfcapsulecrm_custom_field_map' ] ) ) {

            $map_args[ 'custom_field_map' ] = $field[ 'data' ][ 'nfcapsulecrm_custom_field_map' ]; // 
        } else {
            $map_args[ 'custom_field_map' ] = 'Custom Field';
        }


        // For each field in the form, you now have $user_value, $mapped_field, and $entry_type
        // Take each user value and map it where it needs to go

        $request_object->map_field_data( $user_value, $map_args );
    }
    //end foreach field - the end of cycling through every field in the form

    $request_object->finalize_raw_request();
    $raw_request_array = $request_object->get_raw_request_array();

    // communicate with Capsule CRM
    if ( class_exists( 'CapsuleCommunicationPlus' ) ) {
        $capsule_comm_object = new CapsuleCommunicationPlus(
                $nfcapsulecrm_site_options[ 'nfcapsulecrm_authtoken' ], $nfcapsulecrm_site_options[ 'nfcapsulecrm_subdomain' ], $raw_request_array
        );
    } else {
        $capsule_comm_object = new CapsuleV1Communication(
                $nfcapsulecrm_site_options[ 'nfcapsulecrm_authtoken' ], $nfcapsulecrm_site_options[ 'nfcapsulecrm_subdomain' ], $raw_request_array
        );
    }

    // set form settings
    $check_for_existing_person = $ninja_forms_processing->get_form_setting( 'nfcapsulecrm-check-for-existing-person' );
    $form_settings_array[ 'check_for_existing_person' ] = $check_for_existing_person;
    $capsule_comm_object->set_form_settings( $form_settings_array );


    // communicate with Capsule
    $capsule_comm_object->process_form_request();

    // update communication status
    $nfcapsulecrm_comm_data[ 'capsule_comm_status' ] = $capsule_comm_object->get_status_update();

    $raw_response = $capsule_comm_object->get_raw_response();

    // set the most_recent_comm_result string - do not use custom field result, only primary submission
    $nfcapsulecrm_comm_data[ 'most_recent_capsule_comm_result' ] = serialize( $raw_response );


    // record the latest request_array to settings
    $nfcapsulecrm_comm_data[ 'most_recent_capsule_xml_string' ] = serialize( $raw_request_array );

    //update the comm status option
    update_option( 'nfcapsulecrm_comm_data', $nfcapsulecrm_comm_data );
}

// end nfcapsulecrm_process_form

/**
 * Given a field map, modifies it to match newer mapping requirements without changed the saved value.
 * Saves current users from updating each saved form when changed to map values are needed
 * 
 * @param <type> $field_map  
 * 
 * @return <type>
 */
function nfcapsulecrm_maintain_backwards_mapping_compatability( $field_map ) {

    $rewrite_array = array(
        'about' => 'about.standalone',
        'customField.custom' => 'customField.custom.nil.nil.customPersonFields' , // add module to map to simplify raw request logic
        'organisationName.standalone' =>'name.standalone.nil.nil.organisation'
    );


    if ( isset( $rewrite_array[ $field_map ] ) ) {

        $field_map = $rewrite_array[ $field_map ];
    }



    return $field_map;
}

// end nfcapsulecrm_maintain_backwards_mapping_compatability
