<?php

/* --- NINJA FORMS CAPSULE CRM INTEGRATION --- */


/* ----------
  Register the Capsule Field Mapping Options for All Mappable Fields
  Includes custom field box and Capsule's entry type (home, work, mobile, fax, etc)
  ------------------------------------------------------------------------------------------------------------ */

add_action( 'ninja_forms_edit_field_after_registered', 'nfcapsulecrm_modify_field_defaults', 10 );

function nfcapsulecrm_modify_field_defaults( $field_id ) {

    // Get the field type for the given field
    $field = ninja_forms_get_field_by_id( $field_id );
    $field_type = $field[ 'type' ];

    // Add standard NF fields that will be mapped
    // Special field mapping can be defined in nfcapsulecrm_return_selection_options and assigned here with a string name
    $mappable_nf_fields_array = nfcapsulecrm_build_mappable_nf_fields_array();


    // Build an array of custom fields pulled from other extensions
    $extension_fields_array = nfcapsulecrm_grab_custom_fields_from_extensions();

    //Combine the two arrays into one master array of mappable fields
    //The two are kept separate so that an error in an extension doesn't mess with the default behavior
    $extended_mappable_fields_array = array_merge( $mappable_nf_fields_array, $extension_fields_array );


    if ( isset( $extended_mappable_fields_array[ $field_type ] ) ) {

        // pull the field map options for this field type and build the selection list
        $field_map_options = nfcapsulecrm_return_selection_options( $extended_mappable_fields_array[ $field_type ] );

        foreach ( $field_map_options as $field_map => $map_code ) {

            $field_map_options_array[] = array( 'name' => $field_map, 'value' => $map_code );
        }

        // set variables for mapping field select option
        $type = 'select';
        $label = __( 'Capsule CRM Field Map', 'ninja-forms-capsule-crm' );
        $name = 'nfcapsulecrm_field_map';
        $width = 'thin';
        $options = $field_map_options_array;
        $class = 'widefat';
        $desc = ''; //__( 'Map this field to your Capsule CRM', 'ninja-forms-capsule-crm' );
        $label_class = '';


        // check if this field has a field map already selected
        if ( isset( $field[ 'data' ][ 'nfcapsulecrm_field_map' ] ) ) {
            $value = $field[ 'data' ][ 'nfcapsulecrm_field_map' ];

            if ( 'divider' == $value ) {

                $value = 'none';
            }
        } else {

            $value = 'none';
        }//end is set
        // Add field mapping option to the field
        ninja_forms_edit_field_el_output(
                $field_id
                , $type
                , $label
                , $name
                , $value
                , $width
                , $options
                , $class
                , $desc
                , $label_class
        );


        /* --- Create the Custom Field Map Box --- */

        // set variables for mapping field textbox option
        $type = 'text';
        $label = __( 'Custom Capsule Field Map', 'ninja-forms-capsule-crm' );
        $name = 'nfcapsulecrm_custom_field_map';
        $width = 'thin';
        $options = '';
        $class = 'widefat';
        $desc = '';


        //check if this field has a field map already selected
        if ( isset( $field[ 'data' ][ 'nfcapsulecrm_custom_field_map' ] ) ) {

            $value = $field[ 'data' ][ 'nfcapsulecrm_custom_field_map' ];
        } else {

            $value = '';
        }//end is set
        // Add custom field map text box to this field
        ninja_forms_edit_field_el_output(
                $field_id
                , $type
                , $label
                , $name
                , $value
                , $width
                , $options
                , $class
                , $desc
                , $label_class
        );



        /* --- Create the Entry Type Box --- */

        // Entry type can be Home Work Mobile Fax Direct Postal
        // Not all entry types will apply to all field maps; data processing will use only valid maps depending on mapping context
        // create entry_type dropdown	
        $field_map_options = nfcapsulecrm_return_selection_options( 'entry_type' );
        $field_map_options_array = array();

        foreach ( $field_map_options as $field_map => $map_code ) {

            $field_map_options_array[] = array( 'name' => $field_map, 'value' => $map_code );
        }

        // set variables for mapping entry_type textbox option
        $type = 'select';
        $label = __( 'Entry Type', 'ninja-forms-capsule-crm' );
        $name = 'nfcapsulecrm_entry_type';
        $width = 'thin';
        $options = $field_map_options_array;
        $class = 'widefat';
        $desc = '';


        //check if this field has a field map already selected
        if ( isset( $field[ 'data' ][ 'nfcapsulecrm_entry_type' ] ) ) {

            $value = $field[ 'data' ][ 'nfcapsulecrm_entry_type' ];
        } else {

            $value = '';
        }//end is set
        // Add entry_type field map text box to this field
        ninja_forms_edit_field_el_output(
                $field_id
                , $type
                , $label
                , $name
                , $value
                , $width
                , $options
                , $class
                , $desc
                , $label_class
        );
    } //end isset( $extended_mappable_fields_array[ $field_type ] )
}

/* ----------
  Return the selection options for a giving field or option
  Create field map options
  Defaults to full Capsule field list, custom lists are named by a string passed as $map
  ------------------------------------------------------------------------------------------------------------------------ */

// construction for selection value is $mapped_field [, $field_grouping] [,$wrap] [,major_grouping] [,module]
function nfcapsulecrm_return_selection_options( $map = 'entry_type' ) {

    $complete_field_map_options = array(
        __( '- None', 'ninja-forms-capsule-crm' ) => 'none',
        __( 'Title', 'ninja-forms-capsule-crm' ) => 'title.standalone',
        __( 'First Name', 'ninja-forms-capsule-crm' ) => 'firstName.standalone',
        __( 'Last Name', 'ninja-forms-capsule-crm' ) => 'lastName.standalone',
        __( 'Job Title', 'ninja-forms-capsule-crm' ) => 'jobTitle.standalone',
        __( 'About', 'ninja-forms-capsule-crm' ) => 'about.standalone',
        
        __( 'Street', 'ninja-forms-capsule-crm' ) => 'street.address',
        __( 'City', 'ninja-forms-capsule-crm' ) => 'city.address',
        __( 'State', 'ninja-forms-capsule-crm' ) => 'state.address',
        __( 'Zip', 'ninja-forms-capsule-crm' ) => 'zip.address',
        __( 'Country', 'ninja-forms-capsule-crm' ) => 'country.address',
        __( 'Email', 'ninja-forms-capsule-crm' ) => 'emailAddress.single-with-type.email.contacts',
        __( 'Phone', 'ninja-forms-capsule-crm' ) => 'phoneNumber.single-with-type.phone.contacts',
        __( 'URL', 'ninja-forms-capsule-crm' ) => 'URL.website.website.contacts',
        __( 'Skype', 'ninja-forms-capsule-crm' ) => 'SKYPE.website.website.contacts',
        __( 'Twitter', 'ninja-forms-capsule-crm' ) => 'TWITTER.website.website.contacts',
        __( 'Facebook', 'ninja-forms-capsule-crm' ) => 'FACEBOOK.website.website.contacts',
        __( 'Linked In', 'ninja-forms-capsule-crm' ) => 'LINKED_IN.website.website.contacts',
        __( 'Xing', 'ninja-forms-capsule-crm' ) => 'XING.website.website.contacts',
        __( 'Feed', 'ninja-forms-capsule-crm' ) => 'FEED.website.website.contacts',
        __( 'Google Plus', 'ninja-forms-capsule-crm' ) => 'GOOGLE_PLUS.website.website.contacts',
        __( 'Flickr', 'ninja-forms-capsule-crm' ) => 'FLICKR.website.website.contacts',
        __( 'Git Hub', 'ninja-forms-capsule-crm' ) => 'GITHUB.website.website.contacts',
        __( 'YouTube', 'ninja-forms-capsule-crm' ) => 'YOUTUBE.website.website.contacts',
        __( 'Custom (for Person)->', 'ninja-forms-capsule-crm' ) => 'customField.custom',
        __( 'Organisation Name', 'ninja-forms-capsule-crm' ) => 'organisationName.standalone',
        __( 'Organisation About', 'ninja-forms-capsule-crm' ) => 'about.standalone.nil.nil.organisation',
        
        __( 'Organisation Street', 'ninja-forms-capsule-crm' ) => 'street.address.nil.nil.organisation',
        __( 'Organisation City', 'ninja-forms-capsule-crm' ) => 'city.address.nil.nil.organisation',
        __( 'Organisation State', 'ninja-forms-capsule-crm' ) => 'state.address.nil.nil.organisation',
        __( 'Organisation Zip', 'ninja-forms-capsule-crm' ) => 'zip.address.nil.nil.organisation',
        __( 'Organisation Country', 'ninja-forms-capsule-crm' ) => 'country.address.nil.nil.organisation',
        __( 'Organisation Email', 'ninja-forms-capsule-crm' ) => 'emailAddress.single-with-type.email.contacts.organisation',
        __( 'Organisation Phone', 'ninja-forms-capsule-crm' ) => 'phoneNumber.single-with-type.phone.contacts.organisation',
        __( 'Organisation URL', 'ninja-forms-capsule-crm' ) => 'URL.website.website.contacts.organisation',
        __( 'Organisation Skype', 'ninja-forms-capsule-crm' ) => 'SKYPE.website.website.contacts.organisation',
        __( 'Organisation Twitter', 'ninja-forms-capsule-crm' ) => 'TWITTER.website.website.contacts.organisation',
        __( 'Organisation Facebook', 'ninja-forms-capsule-crm' ) => 'FACEBOOK.website.website.contacts.organisation',
        __( 'Organisation Linked In', 'ninja-forms-capsule-crm' ) => 'LINKED_IN.website.website.contacts.organisation',
        __( 'Organisation Xing', 'ninja-forms-capsule-crm' ) => 'XING.website.website.contacts.organisation',
        __( 'Organisation Feed', 'ninja-forms-capsule-crm' ) => 'FEED.website.website.contacts.organisation',
        __( 'Organisation Google Plus', 'ninja-forms-capsule-crm' ) => 'GOOGLE_PLUS.website.website.contacts.organisation',
        __( 'Organisation Flickr', 'ninja-forms-capsule-crm' ) => 'FLICKR.website.website.contacts.organisation',
        __( 'Organisation Git Hub', 'ninja-forms-capsule-crm' ) => 'GITHUB.website.website.contacts.organisation',
        __( 'Organisation YouTube', 'ninja-forms-capsule-crm' ) => 'YOUTUBE.website.website.contacts.organisation',
        
        __( 'Opportunity Name', 'ninja-forms-capsule-crm' ) => 'name.standalone.nil.nil.opportunity',
        __( 'Opportunity Description', 'ninja-forms-capsule-crm' ) => 'description.standalone.nil.nil.opportunity',
        __( 'Opportunity Milestone', 'ninja-forms-capsule-crm' ) => 'milestone.standalone.nil.nil.opportunity',
        __( 'Opportunity Currency', 'ninja-forms-capsule-crm' ) => 'currency.standalone.nil.nil.opportunity',
        __( 'Opportunity Value', 'ninja-forms-capsule-crm' ) => 'value.standalone.nil.nil.opportunity',
        __( 'Opportunity Duration Basis', 'ninja-forms-capsule-crm' ) => 'durationBasis.standalone.nil.nil.opportunity',
        __( 'Opportunity Duration', 'ninja-forms-capsule-crm' ) => 'duration.standalone.nil.nil.opportunity',
        __( 'Opportunity Expected Close', 'ninja-forms-capsule-crm' ) => 'expectedCloseDate.standalone.nil.nil.opportunity',
        __( 'Custom (for Opportunity)->', 'ninja-forms-capsule-crm' ) => 'customField.custom.nil.nil.customOpportunityFields',
        __( 'Task Description', 'ninja-forms-capsule-crm' ) => 'description.standalone.nil.nil.task',
        __( 'Task Days until Due', 'ninja-forms-capsule-crm' ) => 'dueDate.standalone.nil.nil.task',
        __( 'Task Detail', 'ninja-forms-capsule-crm' ) => 'detail.standalone.nil.nil.task',
        __( 'Task Owner', 'ninja-forms-capsule-crm' ) => 'owner.standalone.nil.nil.task',
        __( 'Tag', 'ninja-forms-capsule-crm' ) => 'name.multiples.nil.nil.tags',
        __( 'Note Subject', 'ninja-forms-capsule-crm' ) => 'subject.majorgroup.nil.historyItem.history',
        __( 'Note Content', 'ninja-forms-capsule-crm' ) => 'note.majorgroup.nil.historyItem.history',
    );


    switch ($map) { //create custom selection lists for specific field types
        case 'textarea':
            $field_map_options = array(
                __( '- None', 'ninja-forms-capsule-crm' ) => 'none',
                __( 'About', 'ninja-forms-capsule-crm' ) => 'about',
                __( 'Custom (for Person) ->', 'ninja-forms-capsule-crm' ) => 'customField',
                __( 'Organisation About', 'ninja-forms-capsule-crm' ) => 'about.standalone.nil.nil.organisation',
                __( 'Opportunity Description', 'ninja-forms-capsule-crm' ) => 'description.standalone.nil.nil.opportunity',
                __( 'Custom (for Opportunity)->', 'ninja-forms-capsule-crm' ) => 'customField.custom.nil.nil.customOpportunityFields',
                __( 'Task Detail', 'ninja-forms-capsule-crm' ) => 'description.standalone.nil.nil.task',
                __( 'Note Content', 'ninja-forms-capsule-crm' ) => 'note.majorgroup.nil.historyItem.history',
            );

            break;

        case 'country':
            $field_map_options = array(
                __( '- None', 'ninja-forms-capsule-crm' ) => 'none',
                __( 'Country', 'ninja-forms-capsule-crm' ) => 'country.address',
                __( 'Custom (for Person) ->', 'ninja-forms-capsule-crm' ) => 'customField',
                __( 'Custom (for Opportunity)->', 'ninja-forms-capsule-crm' ) => 'customField.custom.nil.nil.customOpportunityFields',
            );

            break;

        case 'entry_type':
            $field_map_options = array(
                __( '- None', 'ninja-forms-capsule-crm' ) => 'none',
                __( 'Home', 'ninja-forms-capsule-crm' ) => 'Home',
                __( 'Work', 'ninja-forms-capsule-crm' ) => 'Work',
                __( 'Mobile', 'ninja-forms-capsule-crm' ) => 'Mobile',
                __( 'Fax', 'ninja-forms-capsule-crm' ) => 'Fax',
                __( 'Direct', 'ninja-forms-capsule-crm' ) => 'Direct',
                __( 'Postal', 'ninja-forms-capsule-crm' ) => 'Postal',
                __( 'Office', 'ninja-forms-capsule-crm' ) => 'Office',
            );

            break;

        default:
            $field_map_options = $complete_field_map_options; //set a default
    }

    return apply_filters( 'nfcapsulecrm_filter_field_map_options', $field_map_options, $map );
}

// Build an array of standard NF fields that can be mapped to Capsule CRM
function nfcapsulecrm_build_mappable_nf_fields_array() {

    $mappable_nf_fields_array = array();
    $mappable_nf_fields_array[ '_text' ] = '';
    $mappable_nf_fields_array[ '_hidden' ] = '';
    $mappable_nf_fields_array[ '_list' ] = '';
    $mappable_nf_fields_array[ '_textarea' ] = 'textarea';
    $mappable_nf_fields_array[ '_country' ] = 'country';

    return apply_filters( '$nfcapsulecrm_filter_mappable_fields', $mappable_nf_fields_array );
}

/* ----------
  Grab custom fields from other extensions
  Each new extension will require a function in here to build the array
  ------------------------------------------------------------------------------------------------------------------------ */

// User Analytics
function nfcapsulecrm_grab_custom_fields_from_extensions() {

    $extension_fields_array = array();

    // grab User Analytics fields
    global $NF_User_Analytics;

    // Make sure the $NF_User_Analytics variable is available
    if ( isset( $NF_User_Analytics ) ) {

        // access the get_ua_fields() method of the UA class
        $ua_fields = $NF_User_Analytics->get_ua_fields();

        // do whatever you need with the $ua_fields
        foreach ( $ua_fields as $key => $array ) {

            $extension_fields_array[ $key ] = '';
        }
    }

    return $extension_fields_array;
}
