<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Class NF_ConstantContact_Admin_Settings
 */
final class NF_ConstantContact_Admin_Settings
{
    public function __construct()
    {
        add_filter( 'ninja_forms_plugin_settings', array( $this, 'plugin_settings' ), 10, 1 );
        add_filter( 'ninja_forms_plugin_settings_groups', array( $this, 'plugin_settings_groups' ), 10, 1 );
        add_filter( 'ninja_forms_check_setting_constant_contact_access_token', array($this, 'validate_ninja_forms_constant_contact_access_token'), 10, 1);
    }

    public function plugin_settings( $settings )
    {
        $settings[ 'constant_contact' ] = NF_ConstantContact()->config( 'PluginSettings' );
        return $settings;
    }

    public function plugin_settings_groups( $groups )
    {
        $groups = array_merge( $groups, NF_ConstantContact()->config( 'PluginSettingsGroups' ) );
        return $groups;
    }

    public function validate_ninja_forms_constant_contact_access_token( $setting )
    {
        $api_key = trim( $setting[ 'value' ] );

        $api_url  = 'https://api.constantcontact.com/v2/lists?api_key=' . 'd4tkm7yt9chm5bmfc32txtj6';

        $headers = array( 'Authorization' => 'Bearer ' . $api_key );

        $response = wp_remote_get( $api_url, array( 'headers' => $headers, 'sslverify' => false ) );
        
        if( 200 == $response[ 'response' ][ 'code' ] ){
          return $setting;
        } else{
            // TODO: Log Error, $e->getMessage(), for System Status Report
            $setting[ 'errors' ][] = __( 'The Constant Contact Access Token you have entered appears to be invalid.', 'ninja-forms-constant-contact');
            }

        return $setting;
    }

} // End Class NF_ConstantContact_Admin_Settings
