
<?php if ( ! defined( 'ABSPATH' ) ) exit;

// If we have the access key successfully, only show the option to remove connection.
if( NF_AWeber()->is_authorized() ){

    /* Remove Connection */

    $settings['aweber_remove'] = array(
        'id'    => 'aweber_remove',
        'type'  => 'html',
        'label' => __( 'Click button to deauthorize AWeber', 'ninja-forms-aweber' ),
        'html' => '<button type="submit" id="ninja_forms[aweber_remove]" name="ninja_forms[aweber_remove]" class="button-primary" value="1">' . __( 'Remove Connection', 'ninja-forms-aweber' ) . '</button>'
    );


} else {

     /* OAuth Key */

    $settings['aweber_oauth_id'] = array(
        'id'    => 'aweber_oauth_id',
        'type'  => 'textbox',
        'label' => __( 'AWeber Authorization Code', 'ninja-forms-aweber' ),
        'desc'  => sprintf ( __( 'Enter your AWeber Authorization Code. %sClick here to get your authorization code%s.', 'ninja-forms-aweber'), '<a target="_blank" href="https://auth.aweber.com/1.0/oauth/authorize_app/81dfde27">', '</a>' )
    );

}

return apply_filters( 'ninja_forms_aweber_plugin_settings', $settings );