<?php if ( ! defined( 'ABSPATH' ) ) exit;

final class NF_AWeber_Admin_Metaboxes_Submission extends NF_Abstracts_SubmissionMetabox
{
    /**
     * Constructor.
     *
     * @return NF_AWeber_Admin_Metaboxes_Submission
     * 
     * @since  3.0.0
     */  
    public function __construct()
    {
        parent::__construct();

        $this->_title = __( 'AWeber Subscription', 'ninja-forms-aweber' );

        if( $this->sub && ! $this->sub->get_extra_value( '_aweber_data' ) ){
            remove_action( 'add_meta_boxes', array( $this, 'add_meta_boxes' ) );
        }

    }

    /**
     * Get the AWeber tags array out of the form settings.
     *
     * @param array $post
     * @param array $metabox
     * @return void
     * 
     * @since  3.1.0
     */  
    public function render_metabox( $post, $metabox )
    {
        global $post;

        $data = array();

        $aweber_data = (array) $this->sub->get_extra_value( '_aweber_data' );

        foreach( $aweber_data as $list_id => $info ){

            $data[ $list_id ][] = array( 'label' => __( 'List ID', 'ninja-forms-aweber' ), 'value' => $list_id );
            $data[ $list_id ][] = array( 'label' => __( 'List Name', 'ninja-forms-aweber' ), 'value' => NF_AWeber()->list_lookup( $list_id ) );

            if( $info[ 'status' ] == 'subscribed' ){
                $data[ $list_id ][] = array( 'label' => __( 'Status', 'ninja-forms-aweber' ), 'value' => __( 'Subscribed', 'ninja-forms-aweber' ) );
                $data[ $list_id ][] = array( 'label' => __( 'Subscriber ID', 'ninja-forms-aweber' ), 'value' => $info[ 'subcriber_id' ] );
            } elseif( $info[ 'status' ] == 'failed' ) {
                $data[ $list_id ][] = array( 'label' => __( 'Status', 'ninja-forms-aweber' ), 'value' => __( 'Subscription Failed', 'ninja-forms-aweber' ) );
                $data[ $list_id ][] = array( 'label' => __( 'Error Message', 'ninja-forms-aweber' ), 'value' => $info[ 'error' ] );
            } 

        }
        
        NF_AWeber()->template( 'admin-metaboxes-submission.html.php', $data );

    }
}