<?php if ( ! defined( 'ABSPATH' ) || ! class_exists( 'NF_Abstracts_Action' )) exit;

/**
 * Class NF_AWeber_Actions_AWeber
 */
final class NF_AWeber_Actions_AWeber extends NF_Abstracts_ActionNewsletter
{
    /* @var string */
    protected $_name  = 'aweber';

    /* @var array */
    protected $_tags = array();

    /* @var string */
    protected $_timing = 'normal';

    /* @var int */
    protected $_priority = '10';

    /* @var array */
    protected $_custom_fields = array();

    /**
     * Constructor
     */
    public function __construct()
    {
        parent::__construct();

        $this->_nicename = __( 'AWeber', 'ninja-forms-aweber' );
 
        $this->_settings[ 'aweber_tags' ] = array(
            'name' => 'aweber_tags',
            'type' => 'option-repeater',
            'label' => __( 'Tags', 'ninja-forms-aweber' ) . ' <a href="#" class="nf-add-new">' . __( 'Add New', 'ninja-forms-aweber' ) . '</a>',
            'width' => 'full',
            'group' => 'advanced',
            'columns'           => array(
                'value'          => array(
                    'header'    => __( 'Tag', 'ninja-forms-aweber' ),
                    'default'   => '',
                ),
            ),
            'tmpl_row'              => 'tmpl-nf-aweber_tags-repeater-row',
            'use_merge_tags'        => TRUE,
            'max_options'           => 20,
        );
        
        add_action( 'ninja_forms_builder_templates', array( $this, 'load_templates' ) );
        
    }


	/**
	 * Function to output display templates.
	 *
	 * @return void
	 *
	 * @since  3.1.0
	 */
    public function load_templates() {
        // Template path.
        $file_path = NF_AWeber::$dir . '/includes/Templates' . DIRECTORY_SEPARATOR;
        
        // Template file list.
        $template_list = array(
            'drawer-settings'
        );
        
        foreach( $template_list as $template ){
            
            if ( file_exists( $file_path . "$template.html.php" ) ) {
	            NF_AWeber()->template( "$template.html.php" );
            }
        }

	    ?>

	    <?php
    }
   
	/* PUBLIC METHODS */ 
	
	/**
	 * Save routine. Don't need to do anything special.
	 *
	 * @param array $action_settings
	 * @return void
	 * 
	 * @since  3.0.0
	 */
	public function save( $action_settings )
	{

	}
	
	/**
	 * Subscribe a user to AWeber list on form submission.
	 *
	 * @param array $action_settings
	 * @param string $form_id
	 * @param array $data
	 * @return array
	 * 
	 * @since  3.0.0
	 */
    public function process( $action_settings, $form_id, $data )
    {
        if( ! $this->is_opt_in( $data ) ) return $data;
        
        $list_id = $action_settings[ 'newsletter_list' ];

        $merge_vars = $this->get_merge_vars( $action_settings, $list_id );
        
        $merge_vars[ 'aweber_tags' ] = $this->get_tags( $action_settings );

        $data[ 'actions' ][ 'aweber' ][ 'merge_vars' ] = $merge_vars;

        $response = NF_AWeber()->subscribe( $list_id, $merge_vars );

        if( isset( $response['id'] ) ){
            $data[ 'extra' ][ '_aweber_data' ][ $list_id ][ 'status' ] = 'subscribed';
            $data[ 'extra' ][ '_aweber_data' ][ $list_id ][ 'subcriber_id' ] = $response[ 'id' ];
            $data[ 'extra' ][ '_aweber_data' ][ $list_id ][ 'list_id' ] = $response[ 'list' ];
        } elseif ( isset( $response[ 'error' ] ) ){
            $data[ 'extra' ][ '_aweber_data' ][ $list_id ][ 'status' ] = 'failed';
            $data[ 'extra' ][ '_aweber_data' ][ $list_id ][ 'error' ]= $response[ 'error' ];
        } 

        $data[ 'actions' ][ 'aweber' ][ 'subscribe' ] = $response;

        return $data;
    }

	/**
	 * Determine whether user should be subscribed to list.
	 *
	 * @param array $data
	 * @return bool
	 *
	 * @since  3.0.0
	 */
    protected function is_opt_in( $data )
    {
        $opt_in = TRUE;
        foreach( $data[ 'fields' ]as $field ){

            if( 'aweber-optin' != $field[ 'type' ] ) continue;

            if( ! $field[ 'value' ] ) $opt_in = FALSE;
        }
        return $opt_in;
    }

	/**
	 * Get the relevant fields out of the form settings.
	 *
	 * @param array $action_settings
	 * @param string $list_id
	 * @return array
	 * 
	 * @since  3.0.0
	 */
    protected function get_merge_vars( $action_settings, $list_id )
    {
        $merge_vars = array();
       
        foreach( $action_settings as $key => $value ){

            if( FALSE === strpos( $key, $list_id ) ) continue;

            $field = str_replace( $list_id . '_', '', $key );
            $merge_vars[ $field ] = $value;
        }
        return $merge_vars;
    }


	/**
	 * Get the AWeber tags array out of the form settings.
	 *
	 * @param array $action_settings
	 * @return array
	 * 
	 * @since  3.1.0
	 */	  
    protected function get_tags( $action_settings ) {
        
        $tags = array();
        
        // If Convert the tags into a simple array
        if( ! empty( $action_settings[ 'aweber_tags' ] ) ){
            
            foreach( $action_settings[ 'aweber_tags' ] as $tag ){
                $tags[] = trim( $tag[ 'value' ] );
            }
        }
        
        return array_unique( $tags );
    }

	/**
	 * Fetch the AWeber lists for a particular account.
	 *
	 * @return array
	 * 
	 * @since  3.0.0
	 */
    protected function get_lists()
    {
        return NF_AWeber()->get_lists();
    }
    
}
