<?php

/**
 * Register our IP collection field
 *
 * @since       1.1
 * @return      void
 */
function ninja_forms_aweber_add_ip_field(){

	$args = array(
		'name' => __( 'IP Address', 'ninja-forms-aweber' ), // This will be the label of the field button in the back-end editor.
		'display_function' => 'ninja_forms_aweber_collect_user_ip_display', // This function will be called when the form is rendered on the front-end.
		'sidebar' => 'aweber_fields', // This is the sidebar on the Field Settings tab that this field will show up in.
		'display_label' => false, // Since we're adding a hidden form, we don't want to show the label on the front-end.
		'display_wrap' => false, // Again, this is a hidden field, so we don't need the div wrapper that's normally output to the front-end.
		'default_label' => __( 'IP Address', 'ninja-forms-aweber' ),
		'edit_label' => false,
		'edit_desc' => false,
		'edit_label_pos' => false,
		'default_label_pos' => 'above',
		'default_value' => '',
		'edit_req' => false,
		'edit_custom_class' => false,
		'edit_help' => false,
		'edit_meta' => false,
		'edit_conditional' => false,
		'display_label' => false,
		'process_field' => false,
	);

	if( function_exists( 'ninja_forms_register_field' ) ) {
		ninja_forms_register_field( 'ip_address', $args );
	}
}
add_action( 'init', 'ninja_forms_aweber_add_ip_field' );
 

/**
 * Ouput IP collection field
 *
 * @param  		$field_id
 * @param  		$data
 * @since       1.1
 * @return      void
 */
function ninja_forms_aweber_collect_user_ip_display( $field_id, $data ){
    $ip = $_SERVER["REMOTE_ADDR"]; // Get our user's IP address.
    // The "name" attribute below is very important. It has to be ninja_forms_field_$field_id
    ?>
    <input type="hidden" name="ninja_forms_field_<?php echo $field_id;?>" value="<?php echo $ip;?>">
    <?php
}