<?php

/**
 * Register our optin field
 *
 * @since       1.2
 * @return      void
 */
function ninja_forms_aweber_add_optin_field(){

	$nonce = wp_create_nonce( 'ajax_aweber_refresh_nonce' );

	$args = array(
		'name' => __( 'AWeber Signup', 'ninja-forms-aweber' ),
		'edit_options' =>
			array(
				array(
					'type'    => 'select',
					'options' =>
						array(
							array(
								'name'  => __( 'Users must opt-in', 'ninja-forms-aweber' ),
								'value' => 'unchecked',
							),
							array(
								'name'  => __( 'Users must opt-out', 'ninja-forms-aweber' ),
								'value' => 'checked',
							),
							array(
								'name'  => __( 'Hidden', 'ninja-forms-aweber' ),
								'value' => 'hidden',
							),
						),
					'name'    => 'display_mode',
					'label'   => __( 'Display Mode', 'ninja-forms-aweber' ),
					'class'   => 'widefat',
				),
				array(
					'type'    => 'select',
					'options' => NF_AWeber()->get_lists(),
					'name'    => 'aweber_list',
					'label'   => sprintf( __( 'AWeber List %sRefresh lists%s', 'ninja-forms-aweber' ), '<a href="#" style="float:right" data-nonce="'. $nonce . '" class="nf-aweber-refresh"><img class="loader" src="'.NF_PLUGIN_URL.'assets/images/pbar-ani.gif" alt="loading" style="display: none; vertical-align: middle; width: 50px; margin-right: 5px;"/>', '</a>' ),
					'class'   => 'widefat',
				),
			),
		'display_function' => 'ninja_forms_aweber_display_function_optin',
		'sidebar'          => 'aweber_fields',
		'req_validation'   => 'ninja_forms_field_checkbox_validation',
		'edit_label'        => true,
		'edit_label_pos'    => true,
		'label_pos_options' => array(
			array('name' => __( 'Left of Element', 'ninja-forms-aweber' ), 'value' => 'left'),
			array('name' => __( 'Above Element', 'ninja-forms-aweber' ), 'value' => 'above'),
			array('name' => __( 'Below Element', 'ninja-forms-aweber' ), 'value' => 'below'),
			array('name' => __( 'Right of Element', 'ninja-forms-aweber' ), 'value' => 'right'),
		),
	);
	if( function_exists( 'ninja_forms_register_field' ) ) {
		ninja_forms_register_field( 'aweber_optin', $args );
	}
}
add_action( 'init', 'ninja_forms_aweber_add_optin_field' );

/**
 * Display function for the opt in field
 *
 * @param 	int 	$field_id
 * @param 	mixed	$data
 * @return 	void
 */
function ninja_forms_aweber_display_function_optin( $field_id, $data, $form_id = '' ) {

	$field_class = ninja_forms_get_field_class( $field_id, $form_id );

	if( isset( $data['display_mode'] ) ) {

		switch( $data['display_mode'] ) {
			case 'checked':
				$type = 'checkbox';
				$checked = 'checked = "checked"';
			break;
			case 'unchecked':
				$type = 'checkbox';
				$checked = '';
			break;
			default:
				$type = 'hidden';
				$checked = '';
			break;
		}

		?>

	<input id="" name="ninja_forms_field_<?php echo $field_id;?>" type="hidden" value="unchecked" /><input id="ninja_forms_field_<?php echo $field_id;?>" name="ninja_forms_field_<?php echo $field_id;?>" type="<?php echo $type;?>" class="<?php echo $field_class;?>" value="checked" <?php echo $checked;?> rel="<?php echo $field_id;?>"/>
	
	<?php
	}
}



/**
 * Maybe Display Label on Front-end
 *
 * @param 	int 	$field_id
 * @param 	mixed	$data
 * @return 	void
 */
function ninja_forms_aweber_maybe_hide_label( $field_id, $data ) {
	
	if( isset( $data['display_mode'] ) && $data['display_mode'] == 'hidden' ){
		remove_action( 'ninja_forms_display_field_label', 'ninja_forms_display_field_label', 10, 2 );
	} else {
		add_action( 'ninja_forms_display_field_label', 'ninja_forms_display_field_label', 10, 2 );
	}
	
}
add_action( 'ninja_forms_display_before_field', 'ninja_forms_aweber_maybe_hide_label', 10, 2);
