/*!
 * Refresh the dropdown of AWeber Lists
 *
 */

(function($){

// Listen to the user info field group name select list and show the custom name box if custom is selected.
	$('#ninja_forms_field_list').on( 'click', '.nf-aweber-refresh', function(e){
		e.preventDefault();

		$select = $(this).closest('.field-option').find('.ninja-forms-aweber_optin-aweber_list');
		$loader = $(this).find('.loader');

		$.ajax({
			url: ajaxurl,
			method: "POST",
			data: { 
				action: "nf_aweber_refresh", 
				nonce: $(this).data('nonce')
			},
			beforeSend: function( xhr ) {
				$loader.fadeIn();
			    $select.prop( 'disabled', 'true' ).css('css','3px solid red');
			}
		}).done(function(response) {

			var lists = $.parseJSON(response);
		
			if( typeof lists == "object" && lists.length > 1 ){
				$select.empty(); // remove old options
				$.each(lists, function(index, list) {
				  $select.append($("<option></option>").attr("value", list.value).text(list.name));
				});
			}

		}).always(function() {
			$select.removeAttr( 'disabled' );
			$loader.fadeOut();
		});

	});

})(jQuery);
