jQuery(document).ready(function ($) {

	initDropdown('select#trello_boards');
	initDropdown('select#trello_lists');

	$('select#trello_orgs').change(function () {
		var objectid = $('option:selected', this).val();
		resetDropdown('Boards');
		resetDropdown('Lists');
		if (objectid != '0') {
			populateDropdown(objectid, 'boards');
		}

	});

	$('select#trello_boards').change(function () {
		var objectid = $('option:selected', this).val();
		resetDropdown('Lists');
		if (objectid != '0') {
			populateDropdown(objectid, 'lists');
			populateMembers(objectid);
		}
	});

	function populateMembers( id ) {
		var new_object = '#row_card_members td';
		$(new_object).empty();
		$(new_object).append('Retrieving...');
		$.post(ajaxurl,
			{    action: 'nf_trello_get_objects',
				id     : id,
				type   : 'BoardMembers'  },
			function (data) {
				if (data.error) {
					$(new_object).empty();
					alert(data.message);
				} else {
					$(new_object).empty();
					$(new_object).append('<input type="hidden" name="card_members" value="">');
					$.each(data.objects, function (key, val) {
						$(new_object).append('<label><input type="checkbox" class="ninja-forms-card_members " name="card_members[]" value="' + key + '" id="' + val + '">     ' + val + '     </label> ');
					})
				}
			}
			, 'json');
		return false;
	}


	function populateDropdown(id, type) {
		var new_object = 'select#trello_' + type;
		$(new_object).empty();
		$(new_object).append('<option value="0">Retrieving...</option>');
		$.post(ajaxurl,
			{    action: 'nf_trello_get_objects',
				id     : id,
				type   : type  },
			function (data) {
				if (data.error) {
					resetDropdown( type );
					alert(data.message);
				} else {
					$(new_object).empty();
					$.each(data.objects, function (key, val) {
						$(new_object).append('<option value="' + key + '">' + val + '</option>');
					})
					$(new_object).removeAttr('disabled');
				}
			}
			, 'json');
		return false;
	}

	function resetDropdown(type) {
		var object = 'select#trello_' + type.toLowerCase();
		var len = type.length;
		var labeltype = type.substr(0, len - 1);
		$(object).attr('disabled', 'disabled');
		$(object).empty();
		$(object).append('<option value="0">Select ' + labeltype + '</option>');
	}

	function initDropdown(object) {
		if ($(object + ' option').size() == 1) {
			$(object).attr('disabled', 'disabled');
		}
	}
});