<?php if ( ! defined( 'ABSPATH' ) ) exit;

/*
 * Plugin Name: Ninja Forms - Recurly
 * Plugin URI: https://www.ninjaforms.com
 * Description: Integration with the Recurly service for recurring subscription plans.
 * Version: 3.0.3
 * Author: WP Ninjas
 * Author URI: https://www.wpninjas.com
 * Text Domain: ninja-forms-recurly
 *
 * Copyright 2017 WP Ninjas.
 */

if( version_compare( get_option( 'ninja_forms_version', '0.0.0' ), '3', '<' ) || get_option( 'ninja_forms_load_deprecated', FALSE ) ) {

    //include 'deprecated/ninja-forms-recurly.php';

} else {

    /**
     * Class NF_Recurly
     */
    final class NF_Recurly
    {
        const VERSION = '3.0.3';
        const SLUG    = 'recurly';
        const NAME    = 'Recurly';
        const AUTHOR  = 'WP Ninjas';
        const PREFIX  = 'NF_Recurly';

        /**
         * @var NF_Recurly
         * @since 3.0
         */
        private static $instance;

        /**
         * Plugin Directory
         *
         * @since 3.0
         * @var string $dir
         */
        public static $dir = '';

        /**
         * Plugin URL
         *
         * @since 3.0
         * @var string $url
         */
        public static $url = '';

        /**
         * Main Plugin Instance
         *
         * Insures that only one instance of a plugin class exists in memory at any one
         * time. Also prevents needing to define globals all over the place.
         *
         * @since 3.0
         * @static
         * @static var array $instance
         * @return NF_Recurly Highlander Instance
         */
        public static function instance()
        {
            if ( ! isset( self::$instance ) && ! ( self::$instance instanceof NF_Recurly ) ) {
                self::$instance = new NF_Recurly();

                self::$dir = plugin_dir_path(__FILE__);

                self::$url = plugin_dir_url(__FILE__);

                /*
                 * Register our autoloader
                 */
                spl_autoload_register( array( self::$instance, 'autoloader' ) );

                require_once( NF_Recurly::$dir . 'lib/recurly.php' );

            }

            return self::$instance;
        }

        public function __construct()
        {
            add_action( 'init', array( $this, 'setup_vars' ) );

            add_action( 'ninja_forms_before_container', array( $this, 'ninja_forms_before_container' ) );

            /*
             * Required for all Extensions.
             */
            add_action( 'admin_init', array( $this, 'setup_license') );

            add_action( 'ninja_forms_loaded', array( $this, 'setup_admin' ) );

            /*
             * Enqueue our builder JS file.
             */
            add_action( 'nf_admin_enqueue_scripts', array( $this, 'builder_scripts' ) );

            add_action( 'wp_ajax_nf_recurly_fetch_plans', array( $this, 'fetch_plans' ) );

            /*
             * Optional. If your extension processes or alters form submission data on a per form basis...
             */
            add_filter( 'ninja_forms_register_actions', array( $this, 'register_actions') );

            add_filter( 'ninja_forms_field_template_file_paths', array( $this, 'custom_template_path' ) );

            add_action( 'ninja_forms_enqueue_scripts', array( $this, 'enqueue_scripts' ) );

        }

        public function setup_vars() {
            if ( ! function_exists('Ninja_Forms' ) ) return;
            /* https://<your-subdomain>.recurly.com */
            Recurly_Client::$subdomain = Ninja_Forms()->get_setting( 'recurly_subdomain' );
            /* your private API key */
            Recurly_Client::$apiKey = Ninja_Forms()->get_setting( 'recurly_private_key' );;
        }

        public function ninja_forms_before_container( $form_id ) {
          $recurly_action = [];
          foreach( Ninja_Forms()->form( $form_id )->get_actions() as $action ){
            if( 'recurly_subscribe' == $action->get_setting( 'type' ) ){
              $recurly_action = $action;
            }
          }
          if( ! $recurly_action ) return;
          ?>
          <script type="text/javascript">
            var nfRecurlyForm = nfRecurlyForm || {};
            nfRecurlyForm['<?php echo $form_id; ?>'] = JSON.parse('<?php echo json_encode( $recurly_action->get_settings() ); ?>');
          </script>
          <?php
        }

        public function builder_scripts() {
            wp_enqueue_script( 'nf-recurly-builder', NF_Recurly::$url . 'assets/js/recurly-builder.js', array( 'jquery' ) );
        }

        /**
         * Optional. If your extension processes or alters form submission data on a per form basis...
         */
        public function register_actions( $actions )
        {
            $actions[ 'recurly_subscribe' ] = new NF_Recurly_Actions_Subscribe(); // includes/Actions/Recurly.php

            return $actions;
        }

        public function enqueue_scripts( $form_id ) {
            wp_enqueue_style( 'nf-recurly', self::$url . 'assets/css/front-end.css' );
        }

        /*
         * Optional methods for convenience.
         */

        public function autoloader($class_name)
        {
            if (class_exists($class_name)) return;

            if ( false === strpos( $class_name, self::PREFIX ) ) return;

            $class_name = str_replace( self::PREFIX, '', $class_name );
            $classes_dir = realpath(plugin_dir_path(__FILE__)) . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR;
            $class_file = str_replace('_', DIRECTORY_SEPARATOR, $class_name) . '.php';

            if (file_exists($classes_dir . $class_file)) {
                require_once $classes_dir . $class_file;
            }
        }

        /**
         * Template
         *
         * @param string $file_name
         * @param array $data
         */
        public static function template( $file_name = '', array $data = array() )
        {
            if( ! $file_name ) return;

            extract( $data );

            include self::$dir . 'includes/Templates/' . $file_name;
        }

        /**
         * Config
         *
         * @param $file_name
         * @return mixed
         */
        public static function config( $file_name )
        {
            return include self::$dir . 'includes/Config/' . $file_name . '.php';
        }

        /*
         * Required methods for all extension.
         */

        public function setup_license()
        {
            if ( ! class_exists( 'NF_Extension_Updater' ) ) return;

            new NF_Extension_Updater( self::NAME, self::VERSION, self::AUTHOR, __FILE__, self::SLUG );
        }

        public function custom_template_path( $paths ) {
            $paths[] = self::$dir . 'includes/Templates/';
            return $paths;
        }

        /**
         * Setup Admin
         *
         * Setup admin classes for Ninja Forms and WordPress.
         */
        public function setup_admin()
        {
            if( ! is_admin() ) return;

            new NF_Recurly_Admin_Settings();
            new NF_Recurly_Admin_Metaboxes_Submission();
        }
    }

    /**
     * The main function responsible for returning The Highlander Plugin
     * Instance to functions everywhere.
     *
     * Use this function like you would a global variable, except without needing
     * to declare the global.
     *
     * @since 3.0
     * @return {class} Highlander Instance
     */
    function NF_Recurly()
    {
        return NF_Recurly::instance();
    }

    NF_Recurly();
}
