<?php
/**
 * class Recurly_BillingInfo
 * @property string $account_code Account's unique code.
 * @property string $token_id A token generated by Recurly.js
 * @property string $currency Currency in which invoices will be posted. Only applicable if this account is enrolled in a plan has a different currency than your site's default.
 * @property string $first_name First name
 * @property string $last_name Last name
 * @property string $number Credit card number, spaces and dashes are accepted
 * @property int $month Expiration month
 * @property int $year Expiration year
 * @property string $address1 Address line 1, recommended for address validation
 * @property string $address2 Address line 2.
 * @property string $city City
 * @property string $state State
 * @property string $country Country, 2-letter ISO code STRONGLY RECOMMENDED
 * @property string $zip Zip or postal code, recommended for address validation
 * @property string $phone Phone number
 * @property string $company Customer's company
 * @property string $vat_number Customer's VAT Number
 * @property string $currency Currency in which invoices will be posted. Only applicable if this account is enrolled in a plan has a different currency than your site's default.
 * @property string $verification_value Security code or CVV, 3-4 digits STRONGLY RECOMMENDED
 * @property string $ip_address Customer's IP address when updating their Billing Information STRONGLY RECOMMENDED
 */
class Recurly_BillingInfo extends Recurly_Resource
{
  public static function get($accountCode, $client = null) {
    return Recurly_Base::_get(Recurly_BillingInfo::uriForBillingInfo($accountCode), $client);
  }

  public function create() {
    $this->update();
  }
  public function update() {
    $this->_save(Recurly_Client::PUT, $this->uri());
  }

  public function delete() {
    return Recurly_Base::_delete($this->uri(), $this->_client);
  }
  public static function deleteForAccount($accountCode, $client = null) {
    return Recurly_Base::_delete(Recurly_BillingInfo::uriForBillingInfo($accountCode), $client);
  }

  protected function uri() {
    if (!empty($this->_href))
      return $this->getHref();
    else if (!empty($this->account_code))
      return Recurly_BillingInfo::uriForBillingInfo($this->account_code);
    else
      throw new Recurly_Error("'account_code' not specified.");
  }
  protected static function uriForBillingInfo($accountCode) {
    return Recurly_Client::PATH_ACCOUNTS . '/' . rawurlencode($accountCode) . Recurly_Client::PATH_BILLING_INFO;
  }

  protected function getNodeName() {
    return 'billing_info';
  }
  protected function getWriteableAttributes() {
    return array(
      'first_name', 'last_name', 'name_on_account', 'company', 'ip_address',
      'address1', 'address2', 'city', 'state', 'country', 'zip', 'phone',
      'vat_number', 'number', 'month', 'year', 'verification_value',
      'account_number', 'routing_number', 'account_type',
      'paypal_billing_agreement_id', 'amazon_billing_agreement_id', 'currency',
      'token_id'
    );
  }
}
