<?php if ( ! defined( 'ABSPATH' ) ) exit;

$plan_array = array(
    array(
        'label'                     => __( 'Select a Plan', 'ninja-forms-recurly' ),
        'value'                     => '',
    )
);

$cached_plans = get_option( 'nf_recurly_plans', array() );

if ( is_array( $cached_plans ) ) {
    $plan_array = array_merge( $plan_array, $cached_plans );   
}

return apply_filters( 'ninja_forms_recurly_subscribe_settings', array(

    /*
    |--------------------------------------------------------------------------
    | Primary Fields
    |--------------------------------------------------------------------------
    */

    'recurly_plan'                  => array(
        'name'                      => 'recurly_plan',
        'type'                      => 'textbox',
        'group'                     => 'primary',
        'label'                     => __( 'Plan Code', 'ninja-forms-recurly' ),
        'width'                     => 'full',
        'use_merge_tags'            => TRUE,
    ),

    'recurly_basic_info_set'        => array(
        'name'                      => 'recurly_basic_info_set',
        'type'                      => 'fieldset',
        'label'                     => __( 'Basic Info', 'ninja-forms-recurly' ),
        'width'                     => 'full',
        'group'                     => 'primary',
        'settings'                  => array(
            array(
                'name'              => 'recurly_first_name',
                'type'              => 'textbox',
                'label'             => __( 'First Name', 'ninja-forms-recurly' ),
                'width'             => 'one-half',
                'use_merge_tags'    => TRUE,
            ),

            array(
                'name'              => 'recurly_last_name',
                'type'              => 'textbox',
                'label'             => __( 'Last Name', 'ninja-forms-recurly' ),
                'width'             => 'one-half',
                'use_merge_tags'    => TRUE,
            ),

            array(
                'name'              => 'recurly_email',
                'type'              => 'textbox',
                'label'             => __( 'Email', 'ninja-forms-recurly' ),
                'width'             => 'full',
                'use_merge_tags'    => TRUE,
            ),
        ),
    ),

    /*
    |--------------------------------------------------------------------------
    | Advanced Fields
    |--------------------------------------------------------------------------
    */

    'recurly_account_code'          => array(
        'name'                      => 'recurly_account_code',
        'type'                      => 'textbox',
        'group'                     => 'advanced',
        'label'                     => __( 'Account Code', 'ninja-forms-recurly' ),
        'placeholder'               => __( 'Defaults to: firstname_lastname', 'ninja-forms-recurly' ),
        'width'                     => 'one-half',
        'use_merge_tags'            => TRUE,
    ),
    
    'recurly_username'              => array(
        'name'                      => 'recurly_username',
        'type'                      => 'textbox',
        'group'                     => 'advanced',
        'label'                     => __( 'Username', 'ninja-forms-recurly' ),
        'placeholder'               => __( 'Defaults to: firstname_lastname', 'ninja-forms-recurly' ),
        'width'                     => 'one-half',
        'use_merge_tags'            => TRUE,
    ),

    'recurly_company_name'          => array(
        'name'                      => 'recurly_company_name',
        'type'                      => 'textbox',
        'group'                     => 'advanced',
        'label'                     => __( 'Company Name', 'ninja-forms-recurly' ),
        'width'                     => 'one-half',
        'use_merge_tags'            => TRUE,
    ),

    'recurly_vat_number'            => array(
        'name'                      => 'recurly_vat_number',
        'type'                      => 'textbox',
        'group'                     => 'advanced',
        'label'                     => __( 'Vat Number', 'ninja-forms-recurly' ),
        'width'                     => 'one-half',
        'use_merge_tags'            => TRUE,
    ),

    'recurly_tax_exempt'            => array(
        'name'                      => 'recurly_tax_exempt',
        'type'                      => 'toggle',
        'group'                     => 'advanced',
        'label'                     => __( 'Tax Exempt', 'ninja-forms-recurly' ),
        'width'                     => 'one-half',
        'use_merge_tags'            => TRUE,
    ),

    'recurly_address_set'           => array(
        'name'                      => 'recurly_address_set',
        'type'                      => 'fieldset',
        'label'                     => __( 'Address', 'ninja-forms-recurly' ),
        'width'                     => 'full',
        'group'                     => 'advanced',
        'settings'                  => array(
            array(
                'name'              => 'recurly_address1',
                'type'              => 'textbox',
                'width'             => 'one-half',
                'value'             => '',
                'label'             => __( 'Address 1', 'ninja-forms-recurly' ),
                'use_merge_tags'    => TRUE,
            ),
            array(
                'name'              => 'recurly_address2',
                'type'              => 'textbox',
                'width'             => 'one-half',
                'value'             => '',
                'label'             => __( 'Address 2', 'ninja-forms-recurly' ),
                'use_merge_tags'    => TRUE,
            ),
            array(
                'name'              => 'recurly_city',
                'type'              => 'textbox',
                'width'             => 'one-third',
                'value'             => '',
                'label'             => __( 'City', 'ninja-forms-recurly' ),
                'use_merge_tags'    => TRUE,
            ),
            array(
                'name'              => 'recurly_state',
                'type'              => 'textbox',
                'width'             => 'one-third',
                'value'             => '',
                'label'             => __( 'State', 'ninja-forms-recurly' ),
                'use_merge_tags'    => TRUE,
            ),
            array(
                'name'              => 'recurly_zip',
                'type'              => 'textbox',
                'width'             => 'one-third',
                'value'             => '',
                'label'             => __( 'Zip/Postal', 'ninja-forms-recurly' ),
                'use_merge_tags'    => TRUE,
            ),
            array(
                'name'              => 'recurly_country',
                'type'              => 'textbox',
                'width'             => 'full',
                'value'             => '',
                'label'             => __( 'Country', 'ninja-forms-recurly' ),
                'use_merge_tags'    => TRUE,
            ),
            array(
                'name'              => 'recurly_phone',
                'type'              => 'textbox',
                'width'             => 'full',
                'value'             => '',
                'label'             => __( 'Phone', 'ninja-forms-recurly' ),
                'use_merge_tags'    => TRUE,
            ),
            
        ),

    ),


) );