<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Class NF_Recurly_Admin_Settings
 */
final class NF_Recurly_Admin_Settings
{
    public function __construct()
    {
        add_filter( 'ninja_forms_plugin_settings',                  array( $this, 'plugin_settings'             ), 10, 1 );
        add_filter( 'ninja_forms_plugin_settings_groups',           array( $this, 'plugin_settings_groups'      ), 10, 1 );

        add_filter( 'ninja_forms_check_setting_recurly_public_key',  array( $this, 'validate_recurly_public_key_required' ), 10, 1 );
        add_filter( 'ninja_forms_check_setting_recurly_private_key', array( $this, 'validate_recurly_private_key_required' ), 10, 1 );
        add_filter( 'ninja_forms_check_setting_recurly_subdomain',   array( $this, 'validate_recurly_subdomain' ), 10, 1 );

        add_filter( 'ninja_forms_update_setting_recurly_subdomain',  array( $this, 'sanitize_recurly_subdomain' ), 10, 1 );
    }

    public function plugin_settings( $settings )
    {
        $settings[ 'recurly' ] = NF_Recurly()->config( 'PluginSettings' );

        return $settings;
    }

    public function plugin_settings_groups( $groups )
    {
        $groups = array_merge( $groups, NF_Recurly()->config( 'PluginSettingsGroups' ) );
        return $groups;
    }

    public function validate_recurly_public_key_required( $setting ){
      if( ! trim( $setting[ 'value' ] ) ){
        $setting[ 'errors' ][] = __( 'The Recurly Public Key cannot be empty.', 'ninja-forms-recurly' );
      }
      return $setting;
    }

    public function validate_recurly_private_key_required( $setting ){
      if( ! trim( $setting[ 'value' ] ) ){
        $setting[ 'errors' ][] = __( 'The Recurly Private Key cannot be empty.', 'ninja-forms-recurly' );
      }
      return $setting;
    }

    public function validate_recurly_subdomain( $setting ){
      if( ! trim( $setting[ 'value' ] ) ){
        $setting[ 'errors' ][] = __( 'The Recurly Subdomain cannot be empty.', 'ninja-forms-recurly' );
      }
      return $setting;
    }

    public function sanitize_recurly_subdomain( $value )
    {
        $value = str_replace( [ 'https://', 'https:', 'https', 'http://', 'http:', 'http' ], '', $value );
        $value = str_replace( '.recurly.com', '', $value );
        return $value;
    }

} // End Class NF_Recurly_Admin_Settings
