<?php if ( ! defined( 'ABSPATH' ) ) exit;

final class NF_Recurly_Admin_Metaboxes_Submission extends NF_Abstracts_SubmissionMetabox
{
    public function __construct()
    {
        parent::__construct();

        $this->_title = __( 'Recurly', 'ninja-forms-recurly' );

        if( $this->sub && ! $this->sub->get_extra_value( '_recurly_uuid' ) ){
            remove_action( 'add_meta_boxes', array( $this, 'add_meta_boxes' ) );
        }
    }

    public function render_metabox( $post, $metabox )
    {

        $link = '<a target="_blank" href="https://' . Ninja_Forms()->get_setting( 'recurly_subdomain' ) . '.recurly.com/subscriptions/' . $this->sub->get_extra_value( '_recurly_uuid' ) .'">' . __( 'View Subscription', 'ninja-forms-recurly' ) .'</a>';

        $data = array(
            $link
        );

        NF_Recurly::template( 'admin-metaboxes-submission.html.php', $data );
    }
}